/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.propertieseditor;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.jboss.tools.common.editor.AbstractSelectionProvider;
import org.jboss.tools.common.editor.ObjectMultiPageEditor;
import org.jboss.tools.common.editor.ObjectTextEditor;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.propertieseditor.PropertiesEditor;
import org.jboss.tools.common.propertieseditor.text.PropertiesTextEditor;

public class PropertiesCompoundEditor
extends ObjectMultiPageEditor {
    protected PropertiesEditor propertiesEditor;

    public void dispose() {
        super.dispose();
        if (this.propertiesEditor != null) {
            this.propertiesEditor.dispose();
        }
        this.propertiesEditor = null;
    }

    protected void doCreatePages() {
        this.createPropertiesPage();
        this.createTextPage();
        this.initEditors();
    }

    protected void createPropertiesPage() {
        if (this.getModelObject() == null) {
            return;
        }
        this.propertiesEditor = new PropertiesEditor();
        int index = -1;
        try {
            this.propertiesEditor.init(this.getEditorSite(), this.getEditorInput());
            index = this.addPage((IEditorPart)this.propertiesEditor, this.getEditorInput());
        }
        catch (PartInitException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
            return;
        }
        this.setPageText(index, "Properties");
        this.propertiesEditor.setObject(this.object);
        this.propertiesEditor.update();
        this.propertiesEditor.refresh();
    }

    protected ObjectTextEditor createTextEditor() {
        return new PropertiesTextEditor();
    }

    protected void setNormalMode() {
        if (this.treeFormPage != null) {
            this.treeFormPage.initialize(this.getModelObject());
            this.treeFormPage.setErrorMode(this.isErrorMode());
        }
        if (this.propertiesEditor == null) {
            return;
        }
        this.propertiesEditor.setObject(this.object);
        this.propertiesEditor.update();
        this.updateSelectionProvider();
    }

    protected void checkErrorMode() {
    }

    protected void updateEditableMode() {
        if (this.propertiesEditor != null) {
            this.propertiesEditor.update();
        }
    }

    public Object getAdapter(Class cls) {
        return super.getAdapter(cls);
    }

    protected void updateSelectionProvider() {
        int index;
        if (this.propertiesEditor != null) {
            this.selectionProvider.addHost("guiEditor", this.propertiesEditor.getSelectionProvider());
        }
        if (this.textEditor != null) {
            this.selectionProvider.addHost("textEditor", this.getTextSelectionProvider());
        }
        if ((index = this.getActivePage()) == this.getSourcePageIndex()) {
            if (this.textEditor != null) {
                this.selectionProvider.setHost(this.getTextSelectionProvider());
            }
            return;
        }
        if (this.propertiesEditor != null && this.propertiesEditor.getSelectionProvider() != null) {
            ISelectionProvider p = this.propertiesEditor.getSelectionProvider();
            this.selectionProvider.setHost(p);
            if (p instanceof AbstractSelectionProvider) {
                ((AbstractSelectionProvider)p).fireSelectionChanged();
            }
        }
    }

    protected String[] getSupportedNatures() {
        return new String[0];
    }

    protected void synchronizeSelectionWithText() {
        if (this.getTextSelectionProvider() == null || this.propertiesEditor == null) {
            return;
        }
        ISelection s = this.getTextSelectionProvider().getSelection();
        if (s == null || s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return;
        }
        Object o = ((IStructuredSelection)s).getFirstElement();
        if (!(o instanceof XModelObject) || o == this.getModelObject()) {
            return;
        }
        this.propertiesEditor.getSelectionProvider().setSelection(s);
        if (this.outline != null) {
            this.outline.setSelection(s);
        }
    }
}

