/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.cdi;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.DependencyInstaller;
import org.jboss.forge.project.facets.PackagingFacet;
import org.jboss.forge.project.facets.ResourceFacet;
import org.jboss.forge.project.facets.WebResourceFacet;
import org.jboss.forge.project.packaging.PackagingType;
import org.jboss.forge.project.packaging.events.PackagingChanged;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.spec.javaee.BaseJavaEEFacet;
import org.jboss.forge.spec.javaee.CDIFacet;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.cdi.beans.BeansDescriptor;

@Alias(value="forge.spec.cdi")
@RequiresFacet(value={ResourceFacet.class, PackagingFacet.class})
public class CDIFacetImpl
extends BaseJavaEEFacet
implements CDIFacet {
    @Inject
    public CDIFacetImpl(DependencyInstaller installer) {
        super(installer);
    }

    @Override
    public boolean isInstalled() {
        return this.getConfigFile(this.project).exists() && super.isInstalled();
    }

    @Override
    public boolean install() {
        if (!this.isInstalled()) {
            FileResource<?> descriptor = this.getConfigFile(this.project);
            if (!descriptor.createNewFile()) {
                throw new RuntimeException("Failed to create required [" + descriptor.getFullyQualifiedName() + "]");
            }
            descriptor.setContents(((Object)((Object)this)).getClass().getResourceAsStream("/org/jboss/forge/web/beans.xml"));
        }
        return super.install();
    }

    @Override
    protected List<Dependency> getRequiredDependencies() {
        return Arrays.asList(DependencyBuilder.create((String)"javax.enterprise:cdi-api"), DependencyBuilder.create((String)"javax.inject:javax.inject"), DependencyBuilder.create((String)"org.jboss.spec.javax.interceptor:jboss-interceptors-api_1.1_spec"), DependencyBuilder.create((String)"org.jboss.spec.javax.annotation:jboss-annotations-api_1.1_spec"));
    }

    public void updateConfigLocation(@Observes PackagingChanged event) {
        Project project = event.getProject();
        if (project.hasFacet(CDIFacetImpl.class)) {
            PackagingType oldType = event.getOldPackagingType();
            FileResource<?> configFile = this.getConfigFile(project, oldType);
            BeansDescriptor config = this.getConfig(project, configFile);
            this.saveConfig(project, config);
            configFile.delete();
        }
    }

    public FileResource<?> getConfigFile() {
        return this.getConfigFile(this.project);
    }

    private FileResource<?> getConfigFile(Project project) {
        PackagingFacet packaging = (PackagingFacet)project.getFacet(PackagingFacet.class);
        return this.getConfigFile(project, packaging.getPackagingType());
    }

    private FileResource<?> getConfigFile(Project project, PackagingType type) {
        if (PackagingType.WAR.equals((Object)type)) {
            DirectoryResource webRoot = ((WebResourceFacet)project.getFacet(WebResourceFacet.class)).getWebRootDirectory();
            return (FileResource)webRoot.getChild("WEB-INF" + File.separator + "beans.xml");
        }
        DirectoryResource root = ((ResourceFacet)project.getFacet(ResourceFacet.class)).getResourceFolder();
        return (FileResource)root.getChild("META-INF" + File.separator + "beans.xml");
    }

    public BeansDescriptor getConfig() {
        return this.getConfig(this.project, this.getConfigFile(this.project));
    }

    private BeansDescriptor getConfig(Project project, FileResource<?> file) {
        DescriptorImporter importer = Descriptors.importAs(BeansDescriptor.class);
        BeansDescriptor descriptor = (BeansDescriptor)importer.from(file.getResourceInputStream());
        return descriptor;
    }

    public void saveConfig(BeansDescriptor model) {
        this.saveConfig(this.project, model);
    }

    private void saveConfig(Project project, BeansDescriptor descriptor) {
        String output = descriptor.exportAsString();
        this.getConfigFile(project).setContents(output);
    }
}

