/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.validation;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.DependencyInstaller;
import org.jboss.forge.project.dependencies.ScopeType;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.project.facets.ResourceFacet;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.spec.javaee.BaseJavaEEFacet;
import org.jboss.forge.spec.javaee.ValidationFacet;
import org.jboss.forge.spec.javaee.descriptor.ValidationDescriptor;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;

@Alias(value="forge.spec.validation")
@RequiresFacet(value={ResourceFacet.class, DependencyFacet.class})
public class ValidationFacetImpl
extends BaseJavaEEFacet
implements ValidationFacet {
    @Inject
    public ValidationFacetImpl(DependencyInstaller installer) {
        super(installer);
    }

    @Override
    public boolean install() {
        if (!this.isInstalled()) {
            this.saveConfig((ValidationDescriptor)Descriptors.create(ValidationDescriptor.class));
        }
        return super.install();
    }

    @Override
    public boolean isInstalled() {
        return this.getConfigFile().exists() && super.isInstalled();
    }

    @Override
    protected List<Dependency> getRequiredDependencies() {
        return Arrays.asList(DependencyBuilder.create((String)"javax.validation:validation-api").setScopeType(ScopeType.PROVIDED));
    }

    public ValidationDescriptor getConfig() {
        FileResource<?> fileResource = this.getConfigFile();
        if (fileResource.exists()) {
            DescriptorImporter importer = Descriptors.importAs(ValidationDescriptor.class);
            return (ValidationDescriptor)importer.from(fileResource.getResourceInputStream());
        }
        return null;
    }

    public FileResource<?> getConfigFile() {
        ResourceFacet facet = (ResourceFacet)this.project.getFacet(ResourceFacet.class);
        return facet.getResource("META-INF" + File.separator + "validation.xml");
    }

    public void saveConfig(ValidationDescriptor descriptor) {
        FileResource<?> fileResource = this.getConfigFile();
        fileResource.createNewFile();
        fileResource.setContents(descriptor.exportAsString());
    }
}

