/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.validation.util;

import java.io.FileNotFoundException;
import java.lang.annotation.Annotation;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.java.JavaMemberResource;
import org.jboss.forge.resources.java.JavaResource;

public final class ResourceHelper {
    private ResourceHelper() {
    }

    public static boolean hasAnnotation(Resource<?> resource, Class<? extends Annotation> annotationClass) throws FileNotFoundException {
        if (resource == null) {
            throw new IllegalArgumentException("The parameter 'resource' cannot be null");
        }
        if (annotationClass == null) {
            throw new IllegalArgumentException("The parameter 'annotationClass' cannot be null");
        }
        if (resource instanceof JavaResource) {
            JavaClass javaClass = ResourceHelper.getJavaClassFromResource(resource);
            return javaClass.hasAnnotation(annotationClass);
        }
        if (resource instanceof JavaMemberResource) {
            JavaMemberResource javaMemberResource = (JavaMemberResource)resource;
            return javaMemberResource.getUnderlyingResourceObject().hasAnnotation(annotationClass);
        }
        throw new IllegalArgumentException("The given resource '" + resource.getName() + "' is not a Java resource");
    }

    public static JavaClass getJavaClassFromResource(Resource<?> resource) throws FileNotFoundException {
        if (resource == null) {
            throw new IllegalArgumentException("The parameter 'resource' cannot be null");
        }
        if (!(resource instanceof JavaResource)) {
            throw new IllegalArgumentException("The given resource '" + resource.getName() + "' is not a Java resource");
        }
        JavaResource javaResource = (JavaResource)resource;
        JavaSource javaSource = javaResource.getJavaSource();
        if (!javaSource.isClass() && !javaSource.isInterface()) {
            throw new IllegalArgumentException("The given resource '" + resource.getName() + "' is not a class or an interface");
        }
        return (JavaClass)javaResource.getJavaSource();
    }
}

