/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.project;

import java.util.ArrayList;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ArchivesNature
implements IProjectNature {
    public static final String NATURE_ID = "org.jboss.ide.eclipse.archives.core.archivesNature";
    private IProject project;

    public void configure() throws CoreException {
        ArchivesNature.addProjectBuilder(this.project, "org.jboss.ide.eclipse.archives.core.archivesBuilder");
    }

    public void deconfigure() throws CoreException {
        ArchivesNature.removeProjectBuilder(this.project, "org.jboss.ide.eclipse.archives.core.archivesBuilder");
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static boolean addProjectBuilder(IProject project, String builderId) {
        try {
            IProjectDescription desc = project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            ICommand builderCommand = desc.newCommand();
            builderCommand.setBuilderName(builderId);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 0, commands.length);
            newCommands[newCommands.length - 1] = builderCommand;
            desc.setBuildSpec(newCommands);
            project.setDescription(desc, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean removeProjectBuilder(IProject project, String builderId) {
        try {
            IProjectDescription desc = project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            ArrayList<ICommand> newCommands = new ArrayList<ICommand>();
            int i = 0;
            while (i < commands.length) {
                if (!commands[i].getBuilderName().equals(builderId)) {
                    newCommands.add(commands[i]);
                }
                ++i;
            }
            desc.setBuildSpec(newCommands.toArray(new ICommand[newCommands.size()]));
            project.setDescription(desc, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

