/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor.rules;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.Token;

public class GenericDirectiveRule
extends MultiLineRule {
    protected static final char[] START_SEQUENCES = new char[]{'<', '['};
    protected static Map END_SEQUENCES = new HashMap(START_SEQUENCES.length);

    static {
        END_SEQUENCES.put(new Character(START_SEQUENCES[0]), new Character('>'));
        END_SEQUENCES.put(new Character(START_SEQUENCES[1]), new Character(']'));
    }

    public GenericDirectiveRule(IToken token) {
        super("!", "!", token);
    }

    protected boolean sequenceDetected(ICharacterScanner scanner, int startChar, boolean eofAllowed) {
        return true;
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner, int startChar) {
        int i;
        int c;
        char endChar = ((Character)END_SEQUENCES.get(new Character((char)startChar))).charValue();
        char[][] delimiters = scanner.getLegalLineDelimiters();
        boolean previousWasEscapeCharacter = false;
        Stack<String> keyStack = new Stack<String>();
        int charsRead = 0;
        while ((c = scanner.read()) != -1) {
            ++charsRead;
            if (c == startChar) {
                if (keyStack.size() == 0) {
                    break;
                }
            } else if (c == 34) {
                if (keyStack.size() > 0 && keyStack.peek().equals("\"")) {
                    keyStack.pop();
                } else {
                    keyStack.push("\"");
                }
            } else if (c == 40) {
                if (keyStack.size() <= 0 || !keyStack.peek().equals("\"")) {
                    keyStack.push("(");
                }
            } else if (c == 41) {
                if ((keyStack.size() <= 0 || !keyStack.peek().equals("\"")) && keyStack.size() > 0 && keyStack.peek().equals("(")) {
                    keyStack.pop();
                }
            } else if (c == this.fEscapeCharacter) {
                scanner.read();
                ++charsRead;
            } else if (c == endChar) {
                if (keyStack.size() == 0) {
                    return true;
                }
            } else if (this.fBreaksOnEOL) {
                i = 0;
                while (i < delimiters.length) {
                    if (!(c != delimiters[i][0] || !this.sequenceDetected(scanner, delimiters[i], true) || this.fEscapeContinuesLine && previousWasEscapeCharacter)) {
                        return true;
                    }
                    ++i;
                }
            }
            boolean bl = previousWasEscapeCharacter = c == this.fEscapeCharacter;
        }
        if (this.fBreaksOnEOF) {
            return true;
        }
        i = 0;
        while (i < charsRead) {
            scanner.unread();
            ++i;
        }
        return false;
    }

    protected IToken doEvaluate(ICharacterScanner scanner, boolean resume) {
        if (resume) {
            if (this.endSequenceDetected(scanner)) {
                return this.fToken;
            }
        } else {
            int c = scanner.read();
            if (c == START_SEQUENCES[0] || c == START_SEQUENCES[1]) {
                int c2 = scanner.read();
                if (c2 == this.getIdentifierChar() && this.sequenceDetected(scanner, c, false) && this.endSequenceDetected(scanner, c)) {
                    return this.fToken;
                }
                scanner.unread();
            }
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    protected char getIdentifierChar() {
        return '#';
    }
}

