/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.dnd;

import org.eclipse.swt.graphics.Rectangle;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerEditor;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsIEmbeddingSiteWindow;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIWebBrowser;

public class ScrollingSupport {
    private static final int SCROLLING_STEP = 10;
    private static final int SCROLLING_BORDERS = 46;
    private static final int SCROLLBAR_WIDTH = 0;
    private static final int SCROLLBAR_HEIGHT = 0;
    private final XulRunnerEditor xulRunnerEditor;

    public ScrollingSupport(XulRunnerEditor xulRunnerEditor) {
        this.xulRunnerEditor = xulRunnerEditor;
    }

    public void scroll(nsIDOMMouseEvent mouseEvent) {
        nsIWebBrowser webBrowser = this.xulRunnerEditor.getWebBrowser();
        Rectangle rect = this.getWindowBounds();
        int mouseX = mouseEvent.getClientX();
        int mouseY = mouseEvent.getClientY();
        int scrollX = 0;
        int scrollY = 0;
        if (rect.x + 46 > mouseX) {
            scrollX -= 10;
        }
        if (rect.y + 46 > mouseY) {
            scrollY -= 10;
        }
        if (rect.x + rect.width - 46 - 0 < mouseX) {
            scrollX += 10;
        }
        if (rect.y + rect.height - 46 - 0 < mouseY) {
            scrollY += 10;
        }
        if (scrollX != 0 || scrollY != 0) {
            webBrowser.getContentDOMWindow().scrollBy(scrollX, scrollY);
        }
    }

    private Rectangle getWindowBounds() {
        nsIEmbeddingSiteWindow window = (nsIEmbeddingSiteWindow)XPCOM.queryInterface((nsISupports)this.xulRunnerEditor.getWebBrowser().getContainerWindow(), nsIEmbeddingSiteWindow.class);
        int[] xArray = new int[1];
        int[] yArray = new int[1];
        int[] widthArray = new int[1];
        int[] heightArray = new int[1];
        window.getDimensions(2L, xArray, yArray, widthArray, heightArray);
        return new Rectangle(xArray[0], yArray[0], widthArray[0], heightArray[0]);
    }
}

