/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.dnd.context.xpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.wst.common.ui.internal.dnd.DefaultDragAndDropCommand;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DragNodeCommand2
extends DefaultDragAndDropCommand {
    private List fSelections;
    private TreeViewer fTreeViewer;

    public DragNodeCommand2(Object target, float location, int operations, int operation, Collection sources, TreeViewer treeViewer) {
        super(target, location, operations, operation, sources);
        this.fTreeViewer = treeViewer;
        this.fSelections = new ArrayList();
    }

    protected void beginModelChange(Node node, boolean batchUpdate) {
        IStructuredModel structuredModel = this.getStructuredModel(node);
        if (structuredModel != null) {
            String undoDesc = "";
            if (this.getOperation() == 2) {
                undoDesc = XMLUIMessages.DragNodeCommand_0;
            } else if (this.getOperation() == 1) {
                undoDesc = XMLUIMessages.DragNodeCommand_1;
            }
            structuredModel.beginRecording((Object)this, undoDesc);
        }
    }

    public boolean canExecute() {
        return this.executeHelper(true);
    }

    protected boolean doModify(Node source, Node parentNode, Node refChild, boolean testOnly) {
        boolean result = false;
        if (source.getNodeType() == 2) {
            Attr sourceAttribute = (Attr)source;
            Element sourceAttributeOwnerElement = sourceAttribute.getOwnerElement();
            if (parentNode.getNodeType() == 1 && sourceAttributeOwnerElement != parentNode) {
                result = true;
                if (!testOnly) {
                    if (this.getOperation() == 2) {
                        Element targetElement = (Element)parentNode;
                        sourceAttributeOwnerElement.removeAttributeNode(sourceAttribute);
                        targetElement.getAttributes().setNamedItem(sourceAttribute);
                        this.fSelections.add(sourceAttribute);
                    } else if (this.getOperation() == 1) {
                        Attr cloneAttribute = (Attr)sourceAttribute.cloneNode(false);
                        Element targetElement = (Element)parentNode;
                        targetElement.getAttributes().setNamedItem(cloneAttribute);
                        this.fSelections.add(cloneAttribute);
                    }
                }
            }
        } else if (!(parentNode.getNodeType() != 1 && parentNode.getNodeType() != 9 || refChild instanceof Attr)) {
            result = true;
            if (!testOnly && !this.isAncestor(source, parentNode) && source != refChild) {
                if (this.getOperation() == 2) {
                    source.getParentNode().removeChild(source);
                    parentNode.insertBefore(source, refChild);
                    this.fSelections.add(source);
                } else if (this.getOperation() == 1) {
                    Node nodeClone = source.cloneNode(true);
                    parentNode.insertBefore(nodeClone, refChild);
                    this.fSelections.add(nodeClone);
                }
            }
        }
        return result;
    }

    protected void endModelChange(Node node, boolean batchUpdate) {
        IStructuredModel structuredModel = this.getStructuredModel(node);
        if (structuredModel != null) {
            structuredModel.endRecording((Object)this);
        }
    }

    public void execute() {
        this.executeHelper(false);
        if (this.fTreeViewer != null) {
            StructuredSelection structuredSelection = new StructuredSelection(this.fSelections);
            this.fTreeViewer.setSelection((ISelection)structuredSelection);
        }
    }

    protected boolean executeHelper(boolean testOnly) {
        boolean result = true;
        if (this.target instanceof Node) {
            boolean performBatchUpdate;
            Node targetNode = (Node)this.target;
            Node parentNode = this.getParentForDropPosition(targetNode);
            Node refChild = this.getRefChild(targetNode);
            Vector sourcesList = new Vector();
            sourcesList.addAll(this.sources);
            this.removeMemberDescendants(sourcesList);
            boolean bl = performBatchUpdate = sourcesList.size() > 5;
            if (!testOnly) {
                this.beginModelChange(targetNode, performBatchUpdate);
            }
            for (Object source : sourcesList) {
                if (source instanceof Node && !(result = refChild != null || !(targetNode instanceof Attr) ? this.doModify((Node)source, parentNode, refChild, testOnly) : false)) break;
            }
            if (!testOnly) {
                this.endModelChange(targetNode, performBatchUpdate);
            }
        } else {
            result = false;
        }
        return result;
    }

    public int getFeedback() {
        int result = 1;
        if ((double)this.location > 0.75) {
            result = 4;
        } else if ((double)this.location < 0.25) {
            result = 2;
        }
        return result;
    }

    protected Node getParentForDropPosition(Node node) {
        Node result = null;
        int feedback = this.getFeedback();
        result = feedback == 1 ? node : this.getParentOrOwner(node);
        return result;
    }

    private Node getParentOrOwner(Node node) {
        return node.getNodeType() == 2 ? ((Attr)node).getOwnerElement() : node.getParentNode();
    }

    protected Node getRefChild(Node node) {
        Node result = null;
        int feedback = this.getFeedback();
        if (feedback == 2) {
            result = node;
        } else if (feedback == 4) {
            result = node.getNextSibling();
        }
        return result;
    }

    private IStructuredModel getStructuredModel(Node node) {
        IDOMModel result = null;
        if (node instanceof IDOMNode) {
            result = ((IDOMNode)node).getModel();
        }
        return result;
    }

    private boolean isAncestor(Node a, Node b) {
        boolean result = false;
        Node parent = b;
        while (parent != null) {
            if (parent == a) {
                result = true;
                break;
            }
            parent = parent.getParentNode();
        }
        return result;
    }

    private void removeMemberDescendants(List list) {
        Hashtable table = new Hashtable();
        for (Object node : list) {
            table.put(node, node);
        }
        int i = list.size() - 1;
        while (i >= 0) {
            Object node;
            node = (Node)list.get(i);
            Node parent = this.getParentOrOwner((Node)node);
            while (parent != null) {
                if (table.get(parent) != null) {
                    list.remove(i);
                    break;
                }
                parent = this.getParentOrOwner(parent);
            }
            --i;
        }
    }
}

