/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.preferences;

import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.vpe.editor.template.VpeAnyData;
import org.jboss.tools.vpe.editor.template.VpeEditAnyDialog;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.wizards.ExportImportUserTagsTemplatesWizardDialog;
import org.jboss.tools.vpe.editor.wizards.ExportUserTagsTemplatesWizard;
import org.jboss.tools.vpe.editor.wizards.ImportUserTagsTemplatesWizard;
import org.jboss.tools.vpe.editor.wizards.VpeImportExportWizardsUtils;
import org.jboss.tools.vpe.messages.VpeUIMessages;

public class TemplatesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private static final String[] COLUMNS_NAMES = new String[]{VpeUIMessages.TemplatesTableProvider_TagName, VpeUIMessages.TemplatesTableProvider_TagForDisplay, VpeUIMessages.TemplatesTableProvider_URI, VpeUIMessages.TemplatesTableProvider_Children};
    private static final int[] COLUMNS_WIDTHS = new int[]{50, 50, 90, 40};
    private Table tagsTable;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button exportButton;
    private Button importButton;
    private List<VpeAnyData> tagsList = VpeTemplateManager.getInstance().getAnyTemplates();
    protected boolean tagListWasChanged;

    public String getTitle() {
        return VpeUIMessages.TEMPLATES;
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setFont(parent.getFont());
        this.tagsTable = new Table(composite, 68352);
        TableLayout layout = new TableLayout();
        this.tagsTable.setLayout((Layout)layout);
        this.tagsTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 5));
        this.tagsTable.setHeaderVisible(true);
        this.tagsTable.setLinesVisible(true);
        int i = 0;
        while (i < COLUMNS_NAMES.length) {
            TableColumn column = new TableColumn(this.tagsTable, 0);
            column.setText(COLUMNS_NAMES[i]);
            ColumnWeightData columnLayoutData = new ColumnWeightData(COLUMNS_WIDTHS[i], true);
            layout.addColumnData((ColumnLayoutData)columnLayoutData);
            ++i;
        }
        VpeImportExportWizardsUtils.updateTagsTable(this.tagsTable, this.tagsList, true);
        Listener tableItemSelectionListener = new Listener(){

            public void handleEvent(Event event) {
                TemplatesPreferencePage.this.editButton.setEnabled(true);
                TemplatesPreferencePage.this.removeButton.setEnabled(true);
            }
        };
        this.tagsTable.addListener(13, tableItemSelectionListener);
        this.addButton = new Button(composite, 524288);
        this.addButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.addButton.setText(VpeUIMessages.TemplatesPreferencePage_Add);
        this.editButton = new Button(composite, 524288);
        this.editButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.editButton.setText(VpeUIMessages.TemplatesPreferencePage_Edit);
        this.removeButton = new Button(composite, 524288);
        this.removeButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.removeButton.setText(VpeUIMessages.TemplatesPreferencePage_Remove);
        this.exportButton = new Button(composite, 524288);
        this.exportButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.exportButton.setText(VpeUIMessages.TemplatesPreferencePage_Export);
        this.importButton = new Button(composite, 524288);
        this.importButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.importButton.setText(VpeUIMessages.TemplatesPreferencePage_Import);
        this.evaluateButtonsEnabling();
        this.addButton.addListener(24, (Listener)this);
        this.addButton.addListener(13, (Listener)this);
        this.editButton.addListener(24, (Listener)this);
        this.editButton.addListener(13, (Listener)this);
        this.removeButton.addListener(24, (Listener)this);
        this.removeButton.addListener(13, (Listener)this);
        this.exportButton.addListener(24, (Listener)this);
        this.exportButton.addListener(13, (Listener)this);
        this.importButton.addListener(24, (Listener)this);
        this.importButton.addListener(13, (Listener)this);
        return composite;
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        int selectIndex = this.tagsTable.getSelectionIndex();
        if (source == this.addButton) {
            VpeAnyData data = new VpeAnyData("", "", "");
            VpeEditAnyDialog editDialog = new VpeEditAnyDialog(this.getShell(), data, this.tagsList);
            editDialog.open();
            if (data.isChanged()) {
                this.tagsList.add(data);
                this.tagListWasChanged = true;
                this.evaluateButtonsEnabling();
            }
        } else if (source == this.editButton) {
            if (selectIndex > -1) {
                VpeAnyData data = this.tagsList.get(selectIndex);
                VpeEditAnyDialog editDialog = new VpeEditAnyDialog(this.getShell(), data, this.tagsList);
                editDialog.open();
                if (data.isChanged()) {
                    this.tagListWasChanged = true;
                    for (VpeAnyData tag : this.tagsList) {
                        if (tag.equals(data) || !tag.getName().split(":")[0].equalsIgnoreCase(data.getName().split(":")[0])) continue;
                        tag.setUri(data.getUri());
                    }
                }
            }
        } else if (source == this.removeButton) {
            if (selectIndex > -1) {
                this.tagsTable.remove(selectIndex);
                this.tagsList.remove(selectIndex);
                this.tagListWasChanged = true;
                if (selectIndex == 0 && !this.tagsList.isEmpty()) {
                    this.tagsTable.setSelection(selectIndex);
                }
                if (selectIndex > 0) {
                    this.tagsTable.setSelection(selectIndex - 1);
                }
                this.evaluateButtonsEnabling();
            }
        } else if (source == this.exportButton) {
            ExportImportUserTagsTemplatesWizardDialog dlg = new ExportImportUserTagsTemplatesWizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)new ExportUserTagsTemplatesWizard(this.tagsList));
            dlg.open();
        } else if (source == this.importButton) {
            ExportImportUserTagsTemplatesWizardDialog dlg = new ExportImportUserTagsTemplatesWizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)new ImportUserTagsTemplatesWizard(this.tagsList));
            dlg.open();
            this.tagsList.addAll(dlg.getImportedList());
            this.evaluateButtonsEnabling();
        }
        VpeImportExportWizardsUtils.updateTagsTable(this.tagsTable, this.tagsList, true);
    }

    public boolean performOk() {
        if (this.tagListWasChanged) {
            VpeTemplateManager.getInstance().setAnyTemplates(this.tagsList);
        }
        return true;
    }

    protected void performApply() {
        this.performOk();
        this.tagsList = VpeTemplateManager.getInstance().getAnyTemplates();
        VpeImportExportWizardsUtils.updateTagsTable(this.tagsTable, this.tagsList, true);
    }

    protected void performDefaults() {
        this.tagsList = VpeTemplateManager.getInstance().getAnyTemplates();
        VpeImportExportWizardsUtils.updateTagsTable(this.tagsTable, this.tagsList, true);
    }

    private void evaluateButtonsEnabling() {
        boolean editButtonEnabling = false;
        boolean removeButtonEnabling = false;
        boolean exportButtonEnabling = false;
        if (!this.tagsList.isEmpty()) {
            exportButtonEnabling = true;
            if (this.tagsTable.getSelection().length != 0) {
                editButtonEnabling = true;
                removeButtonEnabling = true;
            }
        }
        this.editButton.setEnabled(editButtonEnabling);
        this.removeButton.setEnabled(removeButtonEnabling);
        this.exportButton.setEnabled(exportButtonEnabling);
    }
}

