/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.jboss.tools.jst.jsp.selection.SelectionHelper;
import org.jboss.tools.jst.jsp.util.NodesManagingUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.NodeData;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.selection.VpeSelectionController;
import org.jboss.tools.vpe.editor.template.ISelectionManager;
import org.jboss.tools.vpe.editor.template.SelectionData;
import org.jboss.tools.vpe.editor.template.VpeTemplate;
import org.jboss.tools.vpe.editor.util.SelectionUtil;
import org.jboss.tools.vpe.editor.util.TextUtil;
import org.jboss.tools.vpe.editor.util.VpeNodesManagingUtil;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISelection;
import org.w3c.dom.Node;

public class SelectionManager
implements ISelectionManager {
    public static boolean updateSelectionEventFlag = false;
    private VpePageContext pageContext;
    private StructuredTextEditor sourceEditor;
    private VpeSelectionController selectionController;
    private static Pattern START_WHITESPACE = Pattern.compile("(?<=^)(\\s+)");
    private static Pattern END_WHITESPACE = Pattern.compile("(\\s+)(?=$)");

    public SelectionManager(VpePageContext pageContext, StructuredTextEditor sourceEditor, VpeSelectionController selectionController) {
        this.pageContext = pageContext;
        this.sourceEditor = sourceEditor;
        this.selectionController = selectionController;
    }

    @Override
    public boolean isUpdateSelectionEventPerformed() {
        return updateSelectionEventFlag;
    }

    @Override
    public void setUpdateSelectionEventFlag(boolean isPerforming) {
        updateSelectionEventFlag = isPerforming;
    }

    @Override
    public final void setSelection(nsIDOMNode visualNode, int focusOffset, int anchorOffset) {
        int selectionLength;
        int selectionOffset;
        boolean leftToRightSelection;
        this.setUpdateSelectionEventFlag(true);
        if (visualNode == null) {
            return;
        }
        SelectionData selectionData = this.getSelectionData(visualNode);
        if (selectionData == null) {
            return;
        }
        if (selectionData.getVisualNode().getNodeType() != 3 && SelectionUtil.getSelectedNode(this.getPageContext()) == selectionData.getVisualNode()) {
            return;
        }
        boolean bl = leftToRightSelection = anchorOffset <= focusOffset;
        if (selectionData.isNodeEditable()) {
            Point sourceSelectionRange = leftToRightSelection ? SelectionUtil.getSourceSelectionRange(visualNode, anchorOffset, focusOffset, selectionData.getSourceNode()) : SelectionUtil.getSourceSelectionRange(visualNode, focusOffset, anchorOffset, selectionData.getSourceNode());
            selectionOffset = sourceSelectionRange.x;
            selectionLength = sourceSelectionRange.y - sourceSelectionRange.x;
        } else {
            selectionOffset = 0;
            selectionLength = NodesManagingUtil.getNodeLength((Node)selectionData.getSourceNode());
        }
        SelectionUtil.setSourceSelection(this.getPageContext(), selectionData.getSourceNode(), selectionOffset, selectionLength);
        this.refreshVisualNodeSelection();
        this.setUpdateSelectionEventFlag(false);
    }

    private SelectionData getSelectionData(nsIDOMNode visualNode) {
        boolean isNodeEditable;
        Node targetSourceNode;
        nsIDOMNode targetVisualNode;
        VpeNodeMapping nodeMapping = VpeNodesManagingUtil.getNodeMapping(this.getDomMapping(), visualNode);
        if (nodeMapping == null) {
            return null;
        }
        if (nodeMapping instanceof VpeElementMapping) {
            VpeElementMapping elementMapping = (VpeElementMapping)nodeMapping;
            NodeData nodeData = elementMapping.getTemplate().getNodeData(visualNode, elementMapping.getElementData(), this.getDomMapping());
            if (nodeData != null) {
                targetVisualNode = nodeData.getVisualNode();
                if (nodeData.getSourceNode() != null) {
                    targetSourceNode = nodeData.getSourceNode();
                    isNodeEditable = nodeData.isEditable();
                } else {
                    targetSourceNode = elementMapping.getSourceNode();
                    isNodeEditable = false;
                }
            } else {
                targetVisualNode = elementMapping.getVisualNode();
                targetSourceNode = elementMapping.getSourceNode();
                isNodeEditable = false;
            }
        } else {
            targetVisualNode = nodeMapping.getVisualNode();
            targetSourceNode = nodeMapping.getSourceNode();
            isNodeEditable = true;
        }
        SelectionData selectionData = new SelectionData(targetVisualNode, targetSourceNode, isNodeEditable);
        return selectionData;
    }

    @Override
    public final void refreshVisualSelection() {
        this.setUpdateSelectionEventFlag(true);
        this.refreshVisualNodeSelection();
        this.refreshVisualTextSelection();
    }

    private void refreshVisualNodeSelection() {
        if (this.getSourceEditor().getTextViewer() == null) {
            return;
        }
        Point range = SelectionUtil.getSourceSelectionRange(this.getSourceEditor());
        if (range == null) {
            return;
        }
        List<VpeNodeMapping> nodeMappings = SelectionUtil.getNodeMappingsBySourceSelection(this.getSourceEditor(), this.getDomMapping());
        if (nodeMappings == null) {
            return;
        }
        ArrayList<nsIDOMNode> targetVisualNodes = new ArrayList<nsIDOMNode>();
        for (VpeNodeMapping nodeMapping : nodeMappings) {
            if (nodeMapping instanceof VpeElementMapping) {
                VpeElementMapping elementMapping = (VpeElementMapping)nodeMapping;
                targetVisualNodes.add(elementMapping.getTemplate().getVisualNodeBySourcePosition(elementMapping, range, this.getDomMapping()));
                continue;
            }
            targetVisualNodes.add(nodeMapping.getVisualNode());
        }
        this.getPageContext().getVisualBuilder().setSelectionRectangle(targetVisualNodes);
    }

    private void refreshVisualTextSelection() {
        nsIDOMNode targetVisualNode;
        VpeElementMapping elementMapping;
        VpeTemplate template;
        NodeData nodeData;
        if (this.getSourceEditor().getTextViewer() == null) {
            return;
        }
        Point range = SelectionUtil.getSourceSelectionRange(this.getSourceEditor());
        if (range == null) {
            return;
        }
        VpeNodeMapping nodeMapping = SelectionUtil.getNodeMappingBySourceSelection(this.getSourceEditor(), this.getDomMapping());
        if (nodeMapping == null) {
            return;
        }
        SelectionUtil.clearSelection(this.selectionController);
        if (nodeMapping instanceof VpeElementMapping && (nodeData = (template = (elementMapping = (VpeElementMapping)nodeMapping).getTemplate()).getNodeData(targetVisualNode = template.getVisualNodeBySourcePosition(elementMapping, range, this.getDomMapping()), elementMapping.getElementData(), this.getDomMapping())) != null) {
            this.restoreVisualCursorPosition(template, nodeData, range);
        }
    }

    private void restoreVisualCursorPosition(VpeTemplate template, NodeData nodeData, Point selectionRange) {
        if (nodeData != null) {
            nsIDOMNode visualNode = nodeData.getVisualNode();
            Node sourceNode = nodeData.getSourceNode();
            if (selectionRange != null && sourceNode != null && visualNode != null && visualNode.getNodeType() == 3) {
                int focusOffcetReferenceToSourceNode = selectionRange.x - NodesManagingUtil.getStartOffsetNode((Node)sourceNode);
                int anchorOffcetReferenceToSourceNode = selectionRange.x + selectionRange.y - NodesManagingUtil.getStartOffsetNode((Node)sourceNode);
                NodeImpl sourceTextImpl = (NodeImpl)sourceNode;
                int visualNodeFocusOffcet = TextUtil.visualPosition(sourceTextImpl.getValueSource(), focusOffcetReferenceToSourceNode);
                int visualNodeAnchorOffcet = TextUtil.visualPosition(sourceTextImpl.getValueSource(), anchorOffcetReferenceToSourceNode);
                int length = visualNode.getNodeValue().length();
                if (visualNodeFocusOffcet > length || visualNodeAnchorOffcet > length) {
                    return;
                }
                nsISelection selection = this.selectionController.getSelection((short)1);
                if (visualNodeFocusOffcet == visualNodeAnchorOffcet) {
                    selection.collapse(visualNode, visualNodeFocusOffcet);
                } else {
                    int selectionStartOffset = visualNodeFocusOffcet <= visualNodeAnchorOffcet ? visualNodeFocusOffcet : visualNodeAnchorOffcet;
                    int cfr_ignored_0 = selectionRange.x;
                    int sourceSelLength = selectionRange.y;
                    int caretOffset = SelectionHelper.getCaretOffset((StructuredTextEditor)this.sourceEditor);
                    TextImpl txt = null;
                    AttrImpl attr = null;
                    String wholeText = null;
                    boolean sourceIsCorrect = false;
                    int txtStartOffset = -1;
                    int txtEndOffset = -1;
                    int wsStartLength = 0;
                    int wsEndLength = 0;
                    int goodX = 0;
                    int goodY = 0;
                    if (sourceNode instanceof TextImpl) {
                        txt = (TextImpl)sourceNode;
                        wholeText = txt.getSource();
                        txtStartOffset = txt.getStartOffset();
                        txtEndOffset = txt.getEndOffset();
                        sourceIsCorrect = true;
                    } else if (sourceNode instanceof AttrImpl) {
                        attr = (AttrImpl)sourceNode;
                        wholeText = attr.getValueSource();
                        txtStartOffset = attr.getValueRegionStartOffset();
                        txtEndOffset = txtStartOffset + attr.getValueRegionText().length();
                        sourceIsCorrect = true;
                    }
                    if (sourceIsCorrect) {
                        Matcher matcher = START_WHITESPACE.matcher(wholeText);
                        if (matcher.find()) {
                            wsStartLength = matcher.group(1).length();
                        }
                        if ((matcher = END_WHITESPACE.matcher(wholeText)).find()) {
                            wsEndLength = matcher.group(1).length();
                        }
                        goodX = txtStartOffset + wsStartLength;
                        goodY = txtEndOffset - wsEndLength;
                        boolean skip = false;
                        int allowedLength = 0;
                        if (caretOffset >= txtStartOffset && caretOffset <= txtStartOffset + wsStartLength) {
                            allowedLength = wsStartLength - (caretOffset - txtStartOffset);
                            if (sourceSelLength <= allowedLength) {
                                skip = true;
                            }
                        } else if (caretOffset <= txtEndOffset && caretOffset >= txtEndOffset - wsEndLength && sourceSelLength <= wsEndLength && sourceSelLength <= (allowedLength = wsStartLength - (txtEndOffset - caretOffset))) {
                            skip = true;
                        }
                        if (skip) {
                            selection.collapse(visualNode, selectionStartOffset);
                        } else {
                            int newX = selectionRange.x;
                            int newY = selectionRange.y;
                            if (newX < goodX) {
                                if ((newY -= goodX - newX) < 0) {
                                    newY = 0;
                                }
                                newX = goodX;
                            }
                            if (newX + newY > goodY) {
                                newY = goodY - newX;
                            }
                            Point newSrcRange = new Point(newX, newY);
                            int srcStartOffset = newSrcRange.x - NodesManagingUtil.getStartOffsetNode((Node)sourceNode);
                            int srcEndOffset = srcStartOffset + newSrcRange.y;
                            int visualStartOffset = TextUtil.visualPosition(sourceTextImpl.getValueSource(), srcStartOffset);
                            int visualEndOffset = TextUtil.visualPosition(sourceTextImpl.getValueSource(), srcEndOffset);
                            if (visualStartOffset > length || visualEndOffset > length) {
                                return;
                            }
                            boolean toLeft = caretOffset <= newSrcRange.x;
                            boolean toRight = caretOffset >= newSrcRange.x + newSrcRange.y;
                            int min = Math.min(visualStartOffset, visualEndOffset);
                            int max = Math.max(visualStartOffset, visualEndOffset);
                            if (toRight) {
                                selection.collapse(visualNode, min);
                                selection.extend(visualNode, max);
                            } else if (toLeft) {
                                selection.collapse(visualNode, max);
                                selection.extend(visualNode, min);
                            }
                        }
                    }
                }
            }
        }
    }

    protected VpePageContext getPageContext() {
        return this.pageContext;
    }

    protected VpeDomMapping getDomMapping() {
        return this.pageContext.getDomMapping();
    }

    protected StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }
}

