/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.Map;
import org.jboss.tools.jst.jsp.bundle.BundleMap;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractCreator;
import org.jboss.tools.vpe.editor.template.VpeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VpeLoadBundleCreator
extends VpeAbstractCreator {
    private static final String ATTR_BASENAME = "basename";
    private static final String ATTR_VAR = "var";

    VpeLoadBundleCreator(Element bundleElement, VpeDependencyMap dependencyMap) {
        this.build(bundleElement, dependencyMap);
    }

    private void build(Element bundleElement, VpeDependencyMap dependencyMap) {
        dependencyMap.setCreator((VpeCreator)this, VpeExpressionBuilder.attrSignature(ATTR_BASENAME, true));
        dependencyMap.setCreator((VpeCreator)this, VpeExpressionBuilder.attrSignature(ATTR_VAR, true));
    }

    @Override
    public VpeCreatorInfo create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Map visualNodeMap) {
        this.setBundle(pageContext, (Element)sourceNode);
        return null;
    }

    @Override
    public void removeElement(VpePageContext pageContext, Element sourceElement, Map visualNodeMap) {
    }

    @Override
    public void setAttribute(VpePageContext pageContext, Element sourceElement, Map visualNodeMap, String name, String value) {
        this.setBundle(pageContext, sourceElement);
        pageContext.refreshBundleValues();
    }

    @Override
    public void removeAttribute(VpePageContext pageContext, Element sourceElement, Map visualNodeMap, String name) {
        this.setBundle(pageContext, sourceElement);
        pageContext.refreshBundleValues();
    }

    private void setBundle(VpePageContext pageContext, Element sourceElement) {
        String basename = sourceElement.getAttribute(ATTR_BASENAME);
        String var = sourceElement.getAttribute(ATTR_VAR);
        BundleMap bundle = pageContext.getBundle();
        if (basename != null && basename.length() > 0 && var != null && var.length() > 0) {
            bundle.changeBundle(sourceElement.hashCode(), var, basename);
        } else {
            bundle.removeBundle(sourceElement.hashCode());
        }
    }
}

