/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template.custom;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.RecognizedFileImpl;
import org.jboss.tools.common.model.filesystems.impl.SimpleFileImpl;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.project.WebProject;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.custom.VpeCustomStringStorage;
import org.jboss.tools.vpe.editor.util.FileUtil;
import org.jboss.tools.vpe.editor.util.XmlUtil;
import org.w3c.dom.Node;

public class CustomTLDReference {
    private static final String JSF2_CUSTOM_COMPONENT_URI = "http://java.sun.com/jsf/composite/";

    public static IStorage getCustomElementStorage(Node sourceNode, VpePageContext pageContext) {
        List<TaglibData> taglibs = XmlUtil.getTaglibsForNode(sourceNode, pageContext);
        TaglibData sourceNodeTaglib = XmlUtil.getTaglibForPrefix(sourceNode.getPrefix(), taglibs);
        String uri = sourceNodeTaglib.getUri();
        XModelObject xmodel = CustomTLDReference.getCustomTaglibObject(pageContext, uri);
        XModelObject o = xmodel.getChildByPath(String.valueOf(sourceNode.getLocalName()) + "/" + "declaration");
        String sourceAttributeValue = null;
        if (o != null) {
            sourceAttributeValue = o.getAttributeValue("source");
        }
        if (sourceAttributeValue == null) {
            return null;
        }
        if (xmodel instanceof SimpleFileImpl) {
            IFile iFile = ((SimpleFileImpl)xmodel).getFile();
            if (iFile == null) {
                XModelObject sourceFile = xmodel.getParent().getParent().getChildByPath(sourceAttributeValue.substring(1));
                if (sourceFile instanceof RecognizedFileImpl) {
                    String content = ((RecognizedFileImpl)sourceFile).getAsText();
                    String name = ((RecognizedFileImpl)sourceFile).getPresentationString();
                    VpeCustomStringStorage customStorage = new VpeCustomStringStorage(content, name);
                    return customStorage;
                }
                return null;
            }
            IPath pathToSourceFile = iFile.getFullPath();
            pathToSourceFile = pathToSourceFile.removeLastSegments(1);
            pathToSourceFile = pathToSourceFile.append(sourceAttributeValue);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(pathToSourceFile);
            return file;
        }
        return null;
    }

    public static boolean isExistInJsf2CustomComponenets(VpePageContext pageContext, String sourceNodeUri, String sourceNodeName) {
        boolean result = false;
        if ((sourceNodeUri = sourceNodeUri.trim()) != null && sourceNodeUri.startsWith(JSF2_CUSTOM_COMPONENT_URI)) {
            String jsfComponentResourcePath = sourceNodeUri.substring(JSF2_CUSTOM_COMPONENT_URI.length(), sourceNodeUri.length());
            String fileName = pageContext.getEditPart().getEditorInput().getName();
            String jsfComponentExtension = ".xhtml";
            if (fileName != null && fileName.lastIndexOf(46) != -1) {
                String fileExtension = fileName.substring(fileName.lastIndexOf(46), fileName.length());
                if (fileExtension != null && fileExtension.length() > 0) {
                    jsfComponentExtension = fileExtension;
                }
                jsfComponentResourcePath = String.valueOf(jsfComponentResourcePath) + '/' + sourceNodeName + jsfComponentExtension;
                result = FileUtil.isExistsInJSF2Resources(pageContext, jsfComponentResourcePath);
            }
        }
        return result;
    }

    public static IStorage getJsf2CustomComponentStorage(VpePageContext pageContext, String sourceNodeUri, String sourceNodeName) {
        Object result = null;
        if ((sourceNodeUri = sourceNodeUri.trim()) != null && sourceNodeUri.startsWith(JSF2_CUSTOM_COMPONENT_URI)) {
            String jsfComponentResourcePath = sourceNodeUri.substring(JSF2_CUSTOM_COMPONENT_URI.length(), sourceNodeUri.length());
            String fileName = pageContext.getEditPart().getEditorInput().getName();
            String jsfComponentExtension = ".xhtml";
            if (fileName != null && fileName.lastIndexOf(46) != -1) {
                String fileExtension = fileName.substring(fileName.lastIndexOf(46), fileName.length());
                if (fileExtension != null && fileExtension.length() > 0) {
                    jsfComponentExtension = fileExtension;
                }
                jsfComponentResourcePath = String.valueOf(jsfComponentResourcePath) + '/' + sourceNodeName + jsfComponentExtension;
                String fullResourcePath = FileUtil.getJSF2ResourcePath(pageContext, jsfComponentResourcePath);
                result = FileUtil.getFile(pageContext.getEditPart().getEditorInput(), fullResourcePath);
                if (result != null) {
                    return result;
                }
                File fileToOpen = new File(fullResourcePath);
                if (fileToOpen.exists() && fileToOpen.isFile()) {
                    StringBuilder fileContent;
                    block14: {
                        fileContent = new StringBuilder();
                        try {
                            BufferedReader input = new BufferedReader(new FileReader(fileToOpen));
                            try {
                                try {
                                    String line = null;
                                    while ((line = input.readLine()) != null) {
                                        fileContent.append(line);
                                    }
                                }
                                catch (IOException e) {
                                    VpePlugin.reportProblem(e);
                                    input.close();
                                    break block14;
                                }
                            }
                            catch (Throwable throwable) {
                                input.close();
                                throw throwable;
                            }
                            input.close();
                        }
                        catch (FileNotFoundException e) {
                            VpePlugin.reportProblem(e);
                        }
                        catch (IOException e) {
                            VpePlugin.reportProblem(e);
                        }
                    }
                    result = new VpeCustomStringStorage(fileContent.toString(), fileToOpen.getName());
                }
            }
        }
        return result;
    }

    public static boolean isExistInCustomTlds(VpePageContext pageContext, String uri) {
        return CustomTLDReference.getCustomTaglibObject(pageContext, uri) != null;
    }

    private static XModelObject getCustomTaglibObject(VpePageContext pageContext, String uri) {
        IEditorInput editorInput = pageContext.getEditPart().getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            XModel xm = null;
            IProject project = ((IFileEditorInput)editorInput).getFile().getProject();
            IModelNature mn = EclipseResourceUtil.getModelNature((IProject)project);
            if (mn != null) {
                xm = mn.getModel();
            }
            if (xm != null) {
                return WebProject.getInstance((XModel)xm).getTaglibMapping().getTaglibObject(uri);
            }
        }
        return null;
    }
}

