/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.toolbar.format.handler;

import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.jboss.tools.vpe.editor.toolbar.format.BlockFormatController;
import org.jboss.tools.vpe.editor.toolbar.format.FormatControllerManager;
import org.jboss.tools.vpe.editor.toolbar.format.handler.FormatHandler;
import org.w3c.dom.Node;

public class BlockFormatHandler
extends FormatHandler {
    public BlockFormatHandler() {
    }

    public BlockFormatHandler(FormatControllerManager manager) {
        super(manager);
    }

    @Override
    protected void run() {
        BlockFormatController formatController = (BlockFormatController)this.controller;
        String tagName = formatController.getTagName();
        if (tagName == null || tagName.trim().length() == 0) {
            return;
        }
        boolean normal = false;
        if ("normal".equals(tagName)) {
            normal = true;
        }
        Node selectedNode = this.manager.getCurrentSelectedNodeInfo().getNode();
        StructuredTextViewer viewer = this.manager.getVpeController().getPageContext().getSourceBuilder().getStructuredTextViewer();
        Node replacedNode = null;
        Node formatNode = this.getCurrentNodeWithoutFormatingTag(selectedNode);
        Node parentNode = formatNode.getParentNode();
        if (this.isBlockFormatNode(selectedNode)) {
            replacedNode = selectedNode;
        } else if (this.isBlockFormatNode(parentNode)) {
            replacedNode = parentNode;
        }
        if (replacedNode instanceof ElementImpl) {
            if (normal) {
                this.stripElement((ElementImpl)replacedNode, selectedNode, viewer);
            } else {
                this.replaseElementName((ElementImpl)replacedNode, tagName, viewer, selectedNode);
            }
        } else if (!normal) {
            this.insertNewElementAroundNode(tagName, formatNode, viewer, true);
        }
    }

    private boolean isBlockFormatNode(Node node) {
        return node != null && BlockFormatController.TAGS.get(node.getNodeName().toLowerCase()) != null;
    }

    private Node getCurrentNodeWithoutFormatingTag(Node node) {
        Node currentNode = node;
        while (currentNode.getParentNode() != null && (currentNode.getParentNode().getNodeName().equalsIgnoreCase("b") || currentNode.getParentNode().getNodeName().equalsIgnoreCase("i") || currentNode.getParentNode().getNodeName().equalsIgnoreCase("u"))) {
            currentNode = currentNode.getParentNode();
        }
        return currentNode;
    }
}

