/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.tools.jst.jsp.util.NodesManagingUtil;
import org.jboss.tools.vpe.VpePlugin;
import org.mozilla.interfaces.nsIDOMKeyEvent;
import org.w3c.dom.Node;

public class TextUtil {
    private static final int MIN_ISO_CODE_RANGE = 0;
    private static final int MAX_ISO_CODE_RANGE = Integer.MAX_VALUE;
    private static final String CODES_FILE = "htmlCodes.properties";
    private static final String SOURCE_BREAK = "\r\n";
    private static final String VISUAL_BREAK = "\n";
    private static final char SOURCE_SPACE = ' ';
    private static final char VISUAL_SPACE = '\u00a0';
    private static final char CHR_ESC_START = '&';
    private static final char CHR_SHARP = '#';
    private static final char CHR_ESC_STOP = ';';
    private static final char CHR_HEX_FLAG = 'x';
    private static final String SPCHARS = "\f\n\r\t \u2028\u2029";
    private static final Pattern elPattern = Pattern.compile("(#|\\$)\\{\\s*([^\\s])");
    private static final Map<Character, String> textSet = new HashMap<Character, String>();

    static {
        try {
            InputStream is = VpePlugin.getDefault().getBundle().getResource(CODES_FILE).openStream();
            Properties prop = new Properties();
            prop.load(is);
            for (Map.Entry<Object, Object> e : prop.entrySet()) {
                textSet.put(Character.valueOf((char)Integer.parseInt((String)e.getKey())), (String)e.getValue());
            }
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean containsKey(char key) {
        return textSet.containsKey(Character.valueOf(key));
    }

    public static String getValue(char key) {
        return textSet.get(Character.valueOf(key));
    }

    public static String isEcsToLeft(String sourceText, int sourcePosition) {
        String value;
        String s1 = sourceText;
        String s2 = s1.substring(0, Math.min(sourcePosition, s1.length()));
        int startIndex = s2.lastIndexOf(38);
        int endIndex = s2.lastIndexOf(59);
        if (startIndex >= 0 && endIndex >= 0 && endIndex == s2.length() - 1 && textSet.containsValue(value = s2.substring(startIndex, endIndex + 1))) {
            return value;
        }
        return null;
    }

    public static String isEcsToRight(String sourceText, int sourcePosition) {
        String value;
        String s1 = sourceText;
        String s2 = s1.substring(sourcePosition, s1.length());
        int startIndex = s2.indexOf(38);
        int endIndex = s2.indexOf(59);
        if (startIndex >= 0 && endIndex >= 0 && startIndex == 0 && textSet.containsValue(value = s2.substring(startIndex, endIndex + 1))) {
            return value;
        }
        return null;
    }

    public static int checkEscToRight(String sourceText, int sourcePosition) {
        int end;
        if (sourceText != null && sourceText.length() > sourcePosition && sourceText.charAt(sourcePosition) == '&' && (end = sourceText.indexOf(59, sourcePosition)) != -1 && TextUtil.isEsc(sourceText.substring(sourcePosition, end + 1))) {
            return end - sourcePosition + 1;
        }
        return 0;
    }

    public static int checkEscToLeft(String sourceText, int sourcePosition) {
        String cuttedString;
        int start;
        if (sourceText != null && sourceText.length() > sourcePosition && sourceText.charAt(sourcePosition - 1) == ';' && (start = (cuttedString = sourceText.substring(0, sourcePosition)).lastIndexOf(38)) != -1 && TextUtil.isEsc(sourceText.substring(start, sourcePosition))) {
            return start - sourcePosition;
        }
        return 0;
    }

    public static boolean isEsc(String text) {
        if (text.charAt(0) == '&' && text.charAt(text.length() - 1) == ';') {
            int end = text.length() - 1;
            if (text.length() > 2 && text.charAt(1) == '#') {
                int isoCode = -1;
                int radix = text.charAt(2) == 'x' ? 16 : 10;
                int offcet = text.charAt(2) == 'x' ? 3 : 2;
                try {
                    isoCode = Integer.parseInt(text.substring(offcet, end), radix);
                }
                catch (NumberFormatException numberFormatException) {}
                if (isoCode >= 0 && isoCode <= Integer.MAX_VALUE) {
                    return true;
                }
            } else if (textSet.containsValue(text.substring(0, end + 1))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isEcs(String sourceText, String visualText, int visualPosition) {
        String s1 = visualText;
        String s3 = s1.substring(0, Math.min(visualPosition + 1, s1.length()));
        s3 = TextUtil.sourceText(s3);
        int sourceIndex = 0;
        int visualIndex = 0;
        visualIndex = 0;
        while (visualIndex < s3.length()) {
            Character ch = Character.valueOf(s3.charAt(visualIndex));
            String value = textSet.get(ch);
            char sourceChar = sourceText.charAt(sourceIndex);
            if (value != null) {
                if (sourceChar != ch.charValue() || ch.charValue() == '&' && sourceText.indexOf("&amp;", sourceIndex) >= 0) {
                    if (visualIndex == visualPosition) {
                        return true;
                    }
                    sourceIndex += value.length() - 1;
                }
            } else if (s3.charAt(visualIndex) == '\u00a0' && sourceChar != ' ' && sourceChar != '\u00a0') {
                if (visualIndex == visualPosition) {
                    return true;
                }
                sourceIndex += 5;
            }
            ++sourceIndex;
            ++visualIndex;
        }
        return false;
    }

    public static int sourcePosition(String sourceText, String visualText, int visualPosition) {
        int sourceIndex = 0;
        int visualIndex = 0;
        while (sourceIndex < sourceText.length() && visualIndex < visualPosition) {
            char sourceChar = sourceText.charAt(sourceIndex);
            if (sourceChar == '\r') {
                if (visualText.charAt(visualIndex) == '\r') {
                    ++visualIndex;
                }
                ++sourceIndex;
                continue;
            }
            if (sourceChar == '&') {
                int end = sourceText.indexOf(59, sourceIndex + 1);
                if (end != -1 && TextUtil.isEsc(sourceText.substring(sourceIndex, end + 1))) {
                    sourceIndex += end - sourceIndex;
                }
                ++sourceIndex;
                ++visualIndex;
                continue;
            }
            ++sourceIndex;
            ++visualIndex;
        }
        return sourceIndex;
    }

    public static int sourceInnerPosition(String visualText, long visualPosition) {
        visualText = visualText.substring(0, (int)Math.min(visualPosition, (long)visualText.length()));
        String sourceText = visualText.replaceAll(VISUAL_BREAK, SOURCE_BREAK);
        return sourceText.length();
    }

    public static int visualPosition(String sourceText, int sourcePosition) {
        int calcPosition = sourcePosition;
        if (sourceText == null || sourcePosition < 0) {
            return 0;
        }
        int start = sourceText.indexOf(38);
        while (start != -1 && start < sourcePosition && start + 1 < sourceText.length()) {
            int stop = sourceText.indexOf(59, start + 1);
            if (stop == -1) break;
            if (stop < sourcePosition) {
                if (textSet.containsValue(sourceText.substring(start, stop + 1))) {
                    calcPosition -= stop - start;
                }
                if (stop + 1 >= sourceText.length()) break;
                start = sourceText.indexOf(38, stop + 1);
                continue;
            }
            calcPosition -= sourcePosition - start;
            break;
        }
        int endPos = sourcePosition;
        int length = sourceText.length();
        String s1 = sourceText;
        if (length > 0) {
            if (endPos > length) {
                endPos = length;
            }
            s1 = sourceText.substring(0, endPos);
        }
        String s2 = s1.replaceAll(SOURCE_BREAK, VISUAL_BREAK);
        return calcPosition - (s1.length() - s2.length());
    }

    public static int visualInnerPosition(String sourceText, int sourcePosition) {
        sourceText = sourceText.substring(0, Math.min(sourcePosition, sourceText.length()));
        String visualText = sourceText.replaceAll(SOURCE_BREAK, VISUAL_BREAK);
        return visualText.length();
    }

    public static int _visualPosition(String sourceText, int sourcePosition) {
        int delta = 7;
        if (sourcePosition + delta > sourceText.length()) {
            delta = sourceText.length() - sourcePosition;
        }
        int position = Math.min(sourcePosition + delta, sourceText.length());
        String s1 = sourceText.substring(0, position);
        int start1 = s1.length() - delta;
        if (position < sourceText.length()) {
            while (position > sourcePosition) {
                String value;
                int ampersandPosition = s1.lastIndexOf("&");
                int semicolonPosition = s1.lastIndexOf(";");
                position = ampersandPosition > 0 && semicolonPosition > 0 && ampersandPosition < semicolonPosition && semicolonPosition + 1 > sourcePosition ? (textSet.containsValue(value = s1.substring(ampersandPosition, semicolonPosition + 1)) ? ampersandPosition : --position) : (ampersandPosition > 0 && semicolonPosition > 0 && semicolonPosition > sourcePosition ? semicolonPosition + 1 : --position);
                s1 = s1.substring(0, position);
            }
        } else {
            s1 = s1.substring(0, position -= delta);
        }
        int start2 = s1.length();
        int startLength = s1.length();
        String[] strings = textSet.values().toArray(new String[0]);
        int i = 0;
        while (i < strings.length) {
            s1 = s1.replaceAll(strings[i], " ");
            ++i;
        }
        s1 = TextUtil.visualText(s1);
        return sourcePosition - (startLength - s1.length()) - (start1 - start2);
    }

    public static String visualText(String sourceText) {
        return sourceText.replaceAll(SOURCE_BREAK, VISUAL_BREAK);
    }

    public static String sourceText(String visualText) {
        return visualText.replaceAll(VISUAL_BREAK, SOURCE_BREAK).replace('\u00a0', ' ');
    }

    public static boolean isWhitespace(char sourceString) {
        return SPCHARS.indexOf(sourceString) != -1;
    }

    public static boolean isWhitespaceText(String sourceString) {
        if (sourceString != null && sourceString.length() > 0) {
            int i = 0;
            while (i < sourceString.length()) {
                if (!TextUtil.isWhitespace(sourceString.charAt(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static String getChar(nsIDOMKeyEvent keyEvent) {
        long charCode = keyEvent.getCharCode();
        char[] s = new char[]{(char)charCode};
        String str = new String(s);
        if (TextUtil.containsKey(s[0])) {
            str = TextUtil.getValue(s[0]);
        }
        return str;
    }

    public static int getStartELDocumentPosition(Node node) {
        if (node != null && node.getNodeValue() != null && node.getNodeValue().length() > 0) {
            int elPosition = 0;
            Matcher beginELExpresion = elPattern.matcher(node.getNodeValue());
            if (beginELExpresion.find()) {
                elPosition = beginELExpresion.start(2) + 1;
            }
            int offset = NodesManagingUtil.getStartOffsetNode((Node)node) + elPosition;
            return offset;
        }
        return -1;
    }
}

