/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.editors.reveng;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.hibernate.eclipse.console.model.IRevEngParameter;
import org.hibernate.eclipse.mapper.MapperMessages;
import org.hibernate.eclipse.mapper.editors.reveng.FormTextEntryListenerAdapter;
import org.hibernate.eclipse.mapper.editors.reveng.RevEngDetailsPage;
import org.hibernate.eclipse.mapper.editors.reveng.xpl.FormTextEntry;

public class ParamDetailsPage
extends RevEngDetailsPage
implements IDetailsPage,
PropertyChangeListener {
    private FormTextEntry nameEntry;
    private FormTextEntry valueEntry;
    private IRevEngParameter param;

    protected void buildContents(FormToolkit toolkit, Section section, Composite client) {
        section.setText(MapperMessages.ParamDetailsPage_generator_parameter_details);
        section.setDescription(MapperMessages.ParamDetailsPage_set_the_properties_of_the_selected_parameter);
        this.nameEntry = new FormTextEntry(client, toolkit, MapperMessages.ParamDetailsPage_name, 0);
        this.nameEntry.setFormEntryListener(new FormTextEntryListenerAdapter(){

            public void textValueChanged(FormTextEntry entry) {
                ParamDetailsPage.this.param.setName(entry.getValue());
            }
        });
        this.valueEntry = new FormTextEntry(client, toolkit, MapperMessages.ParamDetailsPage_value, 0);
        this.valueEntry.setFormEntryListener(new FormTextEntryListenerAdapter(){

            public void textValueChanged(FormTextEntry entry) {
                ParamDetailsPage.this.param.setValue(entry.getValue());
            }
        });
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IRevEngParameter newParam = (IRevEngParameter)((IStructuredSelection)selection).getFirstElement();
        if (this.param != null) {
            this.param.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (newParam != null) {
            newParam.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.param = newParam;
        this.update();
    }

    private void update() {
        this.nameEntry.setValue(this.param.getName());
        this.valueEntry.setValue(this.param.getValue());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }
}

