/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.extractor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.eclipse.mapper.extractor.HBMInfoExtractor;
import org.hibernate.eclipse.mapper.extractor.HBMInfoHandler;
import org.hibernate.eclipse.nature.HibernateNature;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class ColumnNameHandler
implements HBMInfoHandler {
    private HBMInfoExtractor extractor;

    ColumnNameHandler(HBMInfoExtractor hie) {
        this.extractor = hie;
    }

    public ICompletionProposal[] attributeCompletionProposals(IJavaProject javaProject, Node node, String attributeName, String start, int offset) {
        Table table;
        TableIdentifier nearestTableName;
        ArrayList<Column> columns = new ArrayList<Column>();
        HibernateNature nature = HibernateNature.getHibernateNature((IJavaProject)javaProject);
        if (nature != null && (nearestTableName = this.extractor.getNearestTableName(node)) != null && (table = nature.getTable(nearestTableName)) != null) {
            Iterator tableMappings = table.getColumnIterator();
            while (tableMappings.hasNext()) {
                Column column = (Column)tableMappings.next();
                if (!column.getName().toUpperCase().startsWith(start.toUpperCase())) continue;
                columns.add(column);
            }
        }
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        for (Column element : columns) {
            proposals.add(new CompletionProposal(element.getName(), offset, start.length(), element.getName().length(), null, null, null, null));
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    public IJavaElement getJavaElement(IJavaProject project, Node currentNode, Attr currentAttrNode) {
        return null;
    }
}

