/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.extractor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.hibernate.eclipse.mapper.MapperMessages;
import org.hibernate.eclipse.mapper.extractor.HBMInfoExtractor;
import org.hibernate.eclipse.mapper.extractor.HBMInfoHandler;
import org.hibernate.eclipse.mapper.extractor.HibernateTypeDescriptor;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class GeneratorTypeHandler
implements HBMInfoHandler {
    private final HBMInfoExtractor extractor;

    public GeneratorTypeHandler(HBMInfoExtractor extractor) {
        this.extractor = extractor;
    }

    public ICompletionProposal[] attributeCompletionProposals(IJavaProject project, Node node, String attributeName, String start, int offset) {
        List types = this.extractor.findMatchingGenerators(start);
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>(types.size());
        for (HibernateTypeDescriptor element : types) {
            String extendedinfo = String.valueOf(MapperMessages.GeneratorTypeHandler_generator_type) + element.getName();
            if (element.getReturnClass() != null) {
                extendedinfo = String.valueOf(extendedinfo) + MapperMessages.GeneratorTypeHandler_return_class + element.getReturnClass();
            }
            proposals.add(new CompletionProposal(element.getName(), offset, start.length(), element.getName().length(), null, null, null, extendedinfo));
        }
        try {
            IType typeInterface = project.findType("org.hibernate.id.IdentifierGenerator");
            HashSet alreadyFound = new HashSet();
            if (typeInterface != null) {
                ITypeHierarchy hier = typeInterface.newTypeHierarchy(project, (IProgressMonitor)new NullProgressMonitor());
                IType[] classes = hier.getAllSubtypes(typeInterface);
                this.extractor.generateTypeProposals(start, offset, proposals, alreadyFound, classes, "org.hibernate.id");
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        ICompletionProposal[] result = proposals.toArray(new ICompletionProposal[proposals.size()]);
        return result;
    }

    public IJavaElement getJavaElement(IJavaProject project, Node currentNode, Attr currentAttrNode) {
        return this.extractor.getNearestTypeJavaElement(project, currentNode);
    }
}

