/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.model;

import java.util.List;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.hibernate.eclipse.console.model.IRevEngColumn;
import org.hibernate.eclipse.console.model.IRevEngPrimaryKey;
import org.hibernate.eclipse.console.model.IRevEngTable;
import org.hibernate.eclipse.mapper.model.DOMAdapter;
import org.hibernate.eclipse.mapper.model.DOMModelUtil;
import org.hibernate.eclipse.mapper.model.DOMReverseEngineeringDefinition;
import org.hibernate.eclipse.mapper.model.RevEngColumnAdapter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RevEngTableAdapter
extends DOMAdapter
implements IRevEngTable {
    public RevEngTableAdapter(Node item, DOMReverseEngineeringDefinition model) {
        super(item, model);
    }

    public String getCatalog() {
        String attrib = "catalog";
        String nullValue = null;
        return this.getNodeValue(attrib, nullValue);
    }

    public String getSchema() {
        return this.getNodeValue("schema", null);
    }

    public String getClassname() {
        return this.getNodeValue("class", null);
    }

    public String getName() {
        return this.getNodeValue("name", null);
    }

    public IRevEngPrimaryKey getPrimaryKey() {
        String elementName = "primary-key";
        return (IRevEngPrimaryKey)this.getAdaptedElement(elementName);
    }

    private Object getAdaptedElement(String elementName) {
        List adaptedElements = this.getAdaptedElements((Element)this.getNode(), elementName);
        if (adaptedElements.isEmpty()) {
            return null;
        }
        return adaptedElements.get(0);
    }

    public IRevEngColumn[] getColumns() {
        return this.getColumnList().toArray(new IRevEngColumn[0]);
    }

    private List getColumnList() {
        return this.getAdaptedElements((Element)this.getNode(), "column");
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        this.getModel().tablesChanged(notifier);
        if (changedFeature == null) {
            this.firePropertyChange("unknown-changed-feature", oldValue, newValue);
        } else {
            this.firePropertyChange(((Node)changedFeature).getNodeName(), oldValue, newValue);
        }
    }

    public void setName(String value) {
        this.setAttribute("name", value, "");
    }

    public void setClassname(String value) {
        this.setAttribute("class", value, "");
    }

    public void setCatalog(String value) {
        this.setAttribute("catalog", value, null);
    }

    public void setSchema(String value) {
        this.setAttribute("schema", value, null);
    }

    public void addColumn(IRevEngColumn revCol) {
        this.getNode().appendChild(((RevEngColumnAdapter)revCol).getNode());
        DOMModelUtil.formatNode(this.getNode().getParentNode());
    }

    public void addPrimaryKey() {
        DOMAdapter key = (DOMAdapter)this.getModel().createPrimaryKey();
        this.getNode().insertBefore(key.getNode(), this.getNode().getFirstChild());
        DOMModelUtil.formatNode(this.getNode().getParentNode());
    }
}

