/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;

public abstract class Merger {
    protected final Repository db;
    protected final ObjectReader reader;
    protected final RevWalk walk;
    private ObjectInserter inserter;
    protected RevObject[] sourceObjects;
    protected RevCommit[] sourceCommits;
    protected RevTree[] sourceTrees;

    protected Merger(Repository local) {
        this.db = local;
        this.reader = this.db.newObjectReader();
        this.walk = new RevWalk(this.reader);
    }

    public Repository getRepository() {
        return this.db;
    }

    public ObjectInserter getObjectInserter() {
        if (this.inserter == null) {
            this.inserter = this.getRepository().newObjectInserter();
        }
        return this.inserter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean merge(AnyObjectId ... tips) throws IOException {
        int i;
        this.sourceObjects = new RevObject[tips.length];
        for (i = 0; i < tips.length; ++i) {
            this.sourceObjects[i] = this.walk.parseAny(tips[i]);
        }
        this.sourceCommits = new RevCommit[this.sourceObjects.length];
        for (i = 0; i < this.sourceObjects.length; ++i) {
            try {
                this.sourceCommits[i] = this.walk.parseCommit(this.sourceObjects[i]);
                continue;
            }
            catch (IncorrectObjectTypeException err) {
                this.sourceCommits[i] = null;
            }
        }
        this.sourceTrees = new RevTree[this.sourceObjects.length];
        for (i = 0; i < this.sourceObjects.length; ++i) {
            this.sourceTrees[i] = this.walk.parseTree(this.sourceObjects[i]);
        }
        try {
            boolean ok = this.mergeImpl();
            if (ok && this.inserter != null) {
                this.inserter.flush();
            }
            boolean bl = ok;
            return bl;
        }
        finally {
            if (this.inserter != null) {
                this.inserter.release();
            }
            this.reader.release();
        }
    }

    protected AbstractTreeIterator mergeBase(int aIdx, int bIdx) throws IOException {
        RevCommit base = this.getBaseCommit(aIdx, bIdx);
        return base == null ? new EmptyTreeIterator() : this.openTree(base.getTree());
    }

    public RevCommit getBaseCommit(int aIdx, int bIdx) throws IncorrectObjectTypeException, IOException {
        if (this.sourceCommits[aIdx] == null) {
            throw new IncorrectObjectTypeException((ObjectId)this.sourceObjects[aIdx], "commit");
        }
        if (this.sourceCommits[bIdx] == null) {
            throw new IncorrectObjectTypeException((ObjectId)this.sourceObjects[bIdx], "commit");
        }
        this.walk.reset();
        this.walk.setRevFilter(RevFilter.MERGE_BASE);
        this.walk.markStart(this.sourceCommits[aIdx]);
        this.walk.markStart(this.sourceCommits[bIdx]);
        RevCommit base = this.walk.next();
        if (base == null) {
            return null;
        }
        RevCommit base2 = this.walk.next();
        if (base2 != null) {
            throw new IOException(MessageFormat.format(JGitText.get().multipleMergeBasesFor, this.sourceCommits[aIdx].name(), this.sourceCommits[bIdx].name(), base.name(), base2.name()));
        }
        return base;
    }

    protected AbstractTreeIterator openTree(AnyObjectId treeId) throws IncorrectObjectTypeException, IOException {
        return new CanonicalTreeParser(null, this.reader, treeId);
    }

    protected abstract boolean mergeImpl() throws IOException;

    public abstract ObjectId getResultTreeId();
}

