/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.dfs;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.dfs.DfsConfig;
import org.eclipse.jgit.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.storage.dfs.DfsRefDatabase;
import org.eclipse.jgit.storage.dfs.DfsRepositoryBuilder;
import org.eclipse.jgit.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.storage.file.ReflogReader;

public abstract class DfsRepository
extends Repository {
    private final DfsConfig config = new DfsConfig();
    private final DfsRepositoryDescription description;

    protected DfsRepository(DfsRepositoryBuilder builder) {
        super(builder);
        this.description = builder.getRepositoryDescription();
    }

    public abstract DfsObjDatabase getObjectDatabase();

    public abstract DfsRefDatabase getRefDatabase();

    public DfsRepositoryDescription getDescription() {
        return this.description;
    }

    public boolean exists() throws IOException {
        return this.getRefDatabase().exists();
    }

    public void create(boolean bare) throws IOException {
        if (this.exists()) {
            throw new IOException(MessageFormat.format(JGitText.get().repositoryAlreadyExists, ""));
        }
        String master = "refs/heads/master";
        RefUpdate.Result result = this.updateRef("HEAD", true).link(master);
        if (result != RefUpdate.Result.NEW) {
            throw new IOException(result.name());
        }
    }

    public StoredConfig getConfig() {
        return this.config;
    }

    public void scanForRepoChanges() throws IOException {
        this.getRefDatabase().clearCache();
        this.getObjectDatabase().clearCache();
    }

    public void notifyIndexChanged() {
    }

    public ReflogReader getReflogReader(String refName) throws IOException {
        throw new UnsupportedOperationException();
    }
}

