/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.dfs;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.storage.dfs.DfsReaderOptions;
import org.eclipse.jgit.storage.dfs.DfsRefDatabase;
import org.eclipse.jgit.storage.dfs.DfsRepository;
import org.eclipse.jgit.storage.dfs.DfsRepositoryBuilder;
import org.eclipse.jgit.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.storage.dfs.ReadableChannel;
import org.eclipse.jgit.util.RefList;

public class InMemoryRepository
extends DfsRepository {
    private final DfsObjDatabase objdb = new MemObjDatabase(this);
    private final DfsRefDatabase refdb = new MemRefDatabase();

    public InMemoryRepository(DfsRepository repoDesc) {
        super(new DfsRepositoryBuilder<DfsRepositoryBuilder, InMemoryRepository>(){

            @Override
            public InMemoryRepository build() throws IOException {
                throw new UnsupportedOperationException();
            }
        });
    }

    public DfsObjDatabase getObjectDatabase() {
        return this.objdb;
    }

    public DfsRefDatabase getRefDatabase() {
        return this.refdb;
    }

    private class MemRefDatabase
    extends DfsRefDatabase {
        private final ConcurrentMap<String, Ref> refs;

        MemRefDatabase() {
            super(InMemoryRepository.this);
            this.refs = new ConcurrentHashMap<String, Ref>();
        }

        protected DfsRefDatabase.RefCache scanAllRefs() throws IOException {
            RefList.Builder<Ref> ids = new RefList.Builder<Ref>();
            RefList.Builder<Ref> sym = new RefList.Builder<Ref>();
            for (Ref ref : this.refs.values()) {
                if (ref.isSymbolic()) {
                    sym.add(ref);
                }
                ids.add(ref);
            }
            ids.sort();
            sym.sort();
            return new DfsRefDatabase.RefCache(ids.toRefList(), sym.toRefList());
        }

        protected boolean compareAndPut(Ref oldRef, Ref newRef) throws IOException {
            String name = newRef.getName();
            if (oldRef == null || oldRef.getStorage() == Ref.Storage.NEW) {
                return this.refs.putIfAbsent(name, newRef) == null;
            }
            Ref cur = (Ref)this.refs.get(name);
            if (cur != null && this.eq(cur, oldRef)) {
                return this.refs.replace(name, cur, newRef);
            }
            return false;
        }

        protected boolean compareAndRemove(Ref oldRef) throws IOException {
            String name = oldRef.getName();
            Ref cur = (Ref)this.refs.get(name);
            if (cur != null && this.eq(cur, oldRef)) {
                return this.refs.remove(name, cur);
            }
            return false;
        }

        private boolean eq(Ref a, Ref b) {
            if (a.getObjectId() == null && b.getObjectId() == null) {
                return true;
            }
            if (a.getObjectId() != null) {
                return a.getObjectId().equals(b.getObjectId());
            }
            return false;
        }
    }

    private static class ByteArrayReadableChannel
    implements ReadableChannel {
        private final byte[] data;
        private int position;
        private boolean open = true;

        ByteArrayReadableChannel(byte[] buf) {
            this.data = buf;
        }

        public int read(ByteBuffer dst) {
            int n = Math.min(dst.remaining(), this.data.length - this.position);
            if (n == 0) {
                return -1;
            }
            dst.put(this.data, this.position, n);
            this.position += n;
            return n;
        }

        public void close() {
            this.open = false;
        }

        public boolean isOpen() {
            return this.open;
        }

        public long position() {
            return this.position;
        }

        public void position(long newPosition) {
            this.position = (int)newPosition;
        }

        public long size() {
            return this.data.length;
        }

        public int blockSize() {
            return 0;
        }
    }

    private static abstract class Out
    extends DfsOutputStream {
        private final ByteArrayOutputStream dst = new ByteArrayOutputStream();
        private byte[] data;

        private Out() {
        }

        public void write(byte[] buf, int off, int len) {
            this.data = null;
            this.dst.write(buf, off, len);
        }

        public int read(long position, ByteBuffer buf) {
            byte[] d = this.getData();
            int n = Math.min(buf.remaining(), d.length - (int)position);
            if (n == 0) {
                return -1;
            }
            buf.put(d, (int)position, n);
            return n;
        }

        byte[] getData() {
            if (this.data == null) {
                this.data = this.dst.toByteArray();
            }
            return this.data;
        }

        public abstract void flush();

        public void close() {
            this.flush();
        }
    }

    private static class MemPack
    extends DfsPackDescription {
        private byte[] packFile;
        private byte[] packIndex;

        MemPack(String name, DfsRepositoryDescription repoDesc) {
            super(repoDesc, name);
        }

        static /* synthetic */ byte[] access$002(MemPack x0, byte[] x1) {
            x0.packFile = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$102(MemPack x0, byte[] x1) {
            x0.packIndex = x1;
            return x1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MemObjDatabase
    extends DfsObjDatabase {
        private final AtomicInteger packId;
        private List<DfsPackDescription> packs;

        MemObjDatabase(DfsRepository repo) {
            super(repo, new DfsReaderOptions());
            this.packId = new AtomicInteger();
            this.packs = new ArrayList<DfsPackDescription>();
        }

        @Override
        protected synchronized List<DfsPackDescription> listPacks() {
            return this.packs;
        }

        @Override
        protected DfsPackDescription newPack(DfsObjDatabase.PackSource source) {
            int id = this.packId.incrementAndGet();
            return new MemPack("pack-" + id + "-" + source.name(), this.getRepository().getDescription());
        }

        @Override
        protected synchronized void commitPack(Collection<DfsPackDescription> desc, Collection<DfsPackDescription> replace) {
            ArrayList<DfsPackDescription> n = new ArrayList<DfsPackDescription>(desc.size() + this.packs.size());
            n.addAll(desc);
            n.addAll(this.packs);
            if (replace != null) {
                n.removeAll(replace);
            }
            this.packs = n;
        }

        @Override
        protected void rollbackPack(Collection<DfsPackDescription> desc) {
        }

        @Override
        protected ReadableChannel openPackFile(DfsPackDescription desc) throws FileNotFoundException {
            MemPack memPack = (MemPack)desc;
            if (memPack.packFile == null) {
                throw new FileNotFoundException(desc.getPackName());
            }
            return new ByteArrayReadableChannel(memPack.packFile);
        }

        @Override
        protected ReadableChannel openPackIndex(DfsPackDescription desc) throws FileNotFoundException {
            MemPack memPack = (MemPack)desc;
            if (memPack.packIndex == null) {
                throw new FileNotFoundException(desc.getIndexName());
            }
            return new ByteArrayReadableChannel(memPack.packIndex);
        }

        @Override
        protected DfsOutputStream writePackFile(DfsPackDescription desc) {
            final MemPack memPack = (MemPack)desc;
            return new Out(){

                public void flush() {
                    MemPack.access$002(memPack, this.getData());
                }
            };
        }

        @Override
        protected DfsOutputStream writePackIndex(DfsPackDescription desc) {
            final MemPack memPack = (MemPack)desc;
            return new Out(){

                public void flush() {
                    MemPack.access$102(memPack, this.getData());
                }
            };
        }
    }
}

