/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.ReflogEntry;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflogReader {
    private File logName;

    public ReflogReader(Repository db, String refname) {
        this.logName = new File(db.getDirectory(), "logs/" + refname);
    }

    public ReflogEntry getLastEntry() throws IOException {
        List<ReflogEntry> entries = this.getReverseEntries(1);
        return entries.size() > 0 ? entries.get(0) : null;
    }

    public List<ReflogEntry> getReverseEntries() throws IOException {
        return this.getReverseEntries(Integer.MAX_VALUE);
    }

    public List<ReflogEntry> getReverseEntries(int max) throws IOException {
        byte[] log;
        try {
            log = IO.readFully(this.logName);
        }
        catch (FileNotFoundException e) {
            return Collections.emptyList();
        }
        int rs = RawParseUtils.prevLF(log, log.length);
        ArrayList<ReflogEntry> ret = new ArrayList<ReflogEntry>();
        while (rs >= 0 && max-- > 0) {
            ReflogEntry entry = new ReflogEntry(log, (rs = RawParseUtils.prevLF(log, rs)) < 0 ? 0 : rs + 2);
            ret.add(entry);
        }
        return ret;
    }
}

