/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;

public abstract class SystemReader {
    private static SystemReader INSTANCE = new SystemReader(){
        private volatile String hostname;

        public String getenv(String variable) {
            return System.getenv(variable);
        }

        public String getProperty(String key) {
            return System.getProperty(key);
        }

        public FileBasedConfig openSystemConfig(Config parent, FS fs) {
            File prefix = fs.gitPrefix();
            if (prefix == null) {
                return new FileBasedConfig(null, fs){

                    public void load() {
                    }

                    public boolean isOutdated() {
                        return false;
                    }
                };
            }
            File etc = fs.resolve(prefix, "etc");
            File config = fs.resolve(etc, "gitconfig");
            return new FileBasedConfig(parent, config, fs);
        }

        public FileBasedConfig openUserConfig(Config parent, FS fs) {
            File home = fs.userHome();
            return new FileBasedConfig(parent, new File(home, ".gitconfig"), fs);
        }

        public String getHostname() {
            if (this.hostname == null) {
                try {
                    InetAddress localMachine = InetAddress.getLocalHost();
                    this.hostname = localMachine.getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    this.hostname = "localhost";
                }
                assert (this.hostname != null);
            }
            return this.hostname;
        }

        public long getCurrentTime() {
            return System.currentTimeMillis();
        }

        public int getTimezone(long when) {
            return this.getTimeZone().getOffset(when) / 60000;
        }
    };

    public static SystemReader getInstance() {
        return INSTANCE;
    }

    public static void setInstance(SystemReader newReader) {
        INSTANCE = newReader;
    }

    public abstract String getHostname();

    public abstract String getenv(String var1);

    public abstract String getProperty(String var1);

    public abstract FileBasedConfig openUserConfig(Config var1, FS var2);

    public abstract FileBasedConfig openSystemConfig(Config var1, FS var2);

    public abstract long getCurrentTime();

    public abstract int getTimezone(long var1);

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }
}

