/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.facets;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.jboss.forge.maven.MavenCoreFacet;
import org.jboss.forge.project.Facet;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.project.facets.FacetNotFoundException;
import org.jboss.forge.project.facets.ResourceFacet;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;

@Dependent
@Alias(value="forge.maven.ResourceFacet")
@RequiresFacet(value={MavenCoreFacet.class})
public class MavenResourceFacet
extends BaseFacet
implements ResourceFacet,
Facet {
    private Project project;

    public List<DirectoryResource> getResourceFolders() {
        ArrayList<DirectoryResource> result = new ArrayList<DirectoryResource>();
        result.add(this.getResourceFolder());
        result.add(this.getTestResourceFolder());
        return result;
    }

    public DirectoryResource getResourceFolder() {
        return this.project.getProjectRoot().getChildDirectory("src" + File.separator + "main" + File.separator + "resources");
    }

    public DirectoryResource getTestResourceFolder() {
        return this.project.getProjectRoot().getChildDirectory("src" + File.separator + "test" + File.separator + "resources");
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public boolean isInstalled() {
        try {
            this.project.getFacet(MavenCoreFacet.class);
            return this.getResourceFolder().exists();
        }
        catch (FacetNotFoundException e) {
            return false;
        }
    }

    public boolean install() {
        if (!this.isInstalled()) {
            for (DirectoryResource folder : this.getResourceFolders()) {
                folder.mkdirs();
            }
        }
        return true;
    }

    public FileResource<?> getResource(String relativePath) {
        return (FileResource)this.getResourceFolder().getChild(relativePath);
    }

    public FileResource<?> getTestResource(String relativePath) {
        return (FileResource)this.getTestResourceFolder().getChild(relativePath);
    }

    public FileResource<?> createResource(char[] bytes, String relativeFilename) {
        FileResource file = (FileResource)this.getResourceFolder().getChild(relativeFilename);
        file.setContents(bytes);
        return file;
    }

    public FileResource<?> createTestResource(char[] bytes, String relativeFilename) {
        FileResource file = (FileResource)this.getTestResourceFolder().getChild(relativeFilename);
        file.setContents(bytes);
        return file;
    }
}

