/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.autolayout.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPartViewer;
import org.jboss.tools.hibernate.ui.diagram.editors.autolayout.IDiagramInfo;
import org.jboss.tools.hibernate.ui.diagram.editors.autolayout.IItemInfo;
import org.jboss.tools.hibernate.ui.diagram.editors.autolayout.data.DiagramElementInfo;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmDiagram;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Shape;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.OrmShapeEditPart;

public class DiagramInfo
implements IDiagramInfo {
    protected List<IItemInfo> items = new ArrayList<IItemInfo>();
    protected OrmDiagram diagram;
    protected EditPartViewer viewer;

    public DiagramInfo(EditPartViewer viewer, OrmDiagram diagram) {
        this.viewer = viewer;
        this.diagram = diagram;
        Iterator<Shape> it = diagram.getChildrenIterator();
        while (it.hasNext()) {
            Shape child = it.next();
            if (!(child instanceof OrmShape)) continue;
            OrmShape ormShape = (OrmShape)child;
            if (child.isVisible()) {
                OrmShapeEditPart part = (OrmShapeEditPart)viewer.getEditPartRegistry().get(ormShape);
                int cxFigure = 6000;
                int cyFigure = 1000;
                if (part != null) {
                    IFigure fig = part.getFigure();
                    cxFigure = fig.getPreferredSize().width;
                    cyFigure = fig.getPreferredSize().height;
                }
                DiagramElementInfo item = new DiagramElementInfo(ormShape, cxFigure, cyFigure);
                this.addItem(item);
                continue;
            }
            ormShape.setLocation(new Point(0, 0));
        }
    }

    public IItemInfo[] getItems() {
        return this.items.toArray(new IItemInfo[0]);
    }

    public void addItem(IItemInfo item) {
        this.items.add(item);
    }
}

