/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.autolayout.impl;

import org.jboss.tools.hibernate.ui.diagram.editors.autolayout.impl.Item;

public class TransitionArranger {
    Item[] items;
    private int[] occ0 = new int[10];

    public void setItems(Item[] items) {
        this.items = items;
    }

    public void execute() {
        int maxX = this.getMaxX();
        int maxY = this.getMaxY();
        int[][] occ = new int[this.occ0.length][maxY + 1];
        Item[] v = new Item[maxY + 1];
        int ix = 0;
        while (ix <= maxX) {
            this.clean(occ);
            this.fill(v, ix);
            this.execute(ix, occ, v);
            ++ix;
        }
    }

    private void clean(int[][] occ) {
        int i = 0;
        while (i < occ.length) {
            int j = 0;
            while (j < occ[0].length) {
                occ[i][j] = 0;
                ++j;
            }
            ++i;
        }
    }

    private void fill(Item[] v, int ix) {
        int i = 0;
        while (i < v.length) {
            v[i] = null;
            ++i;
        }
        i = 0;
        while (i < this.items.length) {
            if (this.items[i].inputs.length != 0 && !this.items[i].isOwned && this.items[i].ix == ix) {
                v[this.items[i].iy] = this.items[i];
            }
            ++i;
        }
    }

    private void execute(int ix, int[][] occ, Item[] v) {
        int delta = 0;
        int iy = 0;
        while (iy < v.length) {
            if (v[iy] != null) {
                int i = 0;
                while (i < this.occ0.length) {
                    this.occ0[i] = 0;
                    ++i;
                }
                int[] is = v[iy].inputs;
                delta = 0;
                int k = 0;
                while (k < is.length) {
                    int iy2 = this.items[is[k]].iy;
                    int miny = Math.min(iy, iy2);
                    int maxy = Math.max(iy, iy2);
                    if (maxy - miny > delta) {
                        delta = maxy - miny;
                    }
                    int m = 0;
                    while (m < this.occ0.length) {
                        int y = miny;
                        while (y <= maxy) {
                            if (occ[m][y] > 0) {
                                int n = m;
                                this.occ0[n] = this.occ0[n] + occ[m][y];
                            }
                            ++y;
                        }
                        ++m;
                    }
                    ++k;
                }
                int tg = this.findTransitionLine(delta, this.occ0);
                int k2 = 0;
                while (k2 < is.length) {
                    int iy2 = this.items[is[k2]].iy;
                    int[] nArray = occ[tg];
                    int n = iy2;
                    nArray[n] = nArray[n] + 1;
                    ++k2;
                }
            }
            ++iy;
        }
    }

    private int getMaxX() {
        int ix = 0;
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i].ix > ix) {
                ix = this.items[i].ix;
            }
            ++i;
        }
        return ix;
    }

    private int getMaxY() {
        int iy = 0;
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i].iy > iy) {
                iy = this.items[i].iy;
            }
            ++i;
        }
        return iy;
    }

    private int findTransitionLine(int pref, int[] occ0) {
        if (pref >= occ0.length) {
            pref = occ0.length - 1;
        }
        int h = 1000;
        int p = -1;
        int i = 0;
        while (i < occ0.length) {
            int h1 = occ0[i] * 3 + Math.abs(i - pref);
            if (h1 < h) {
                h = h1;
                p = i;
            }
            ++i;
        }
        return p;
    }
}

