/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Shape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseElement
implements IPropertySource,
Comparable<BaseElement> {
    public static final String CLASS_NAME = "className";
    public static final String SELECTED = "selected";
    public static final String VISIBLE = "visible";
    public static final String VISIBLE_CHILDREN = "visibileChildren";
    public static final String REFRESH = "refresh";
    private static final IPropertyDescriptor[] EMPTY_ARRAY = new IPropertyDescriptor[0];
    private transient PropertyChangeSupport pcsDelegate = new PropertyChangeSupport(this);
    protected boolean selected = false;
    protected boolean visible = true;
    protected boolean visibleChildren = true;
    private ArrayList<Shape> children = new ArrayList();

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (l == null) {
            throw new IllegalArgumentException();
        }
        this.pcsDelegate.addPropertyChangeListener(l);
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        if (this.pcsDelegate.hasListeners(property)) {
            this.pcsDelegate.firePropertyChange(property, oldValue, newValue);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (l != null) {
            this.pcsDelegate.removePropertyChangeListener(l);
        }
    }

    public abstract BaseElement getParent();

    public Iterator<Shape> getChildrenIterator() {
        return this.children.iterator();
    }

    public List<Shape> getChildrenList() {
        ArrayList<Shape> copy = new ArrayList<Shape>();
        Iterator<Shape> it = this.getChildrenIterator();
        while (it.hasNext()) {
            copy.add(it.next());
        }
        return copy;
    }

    public int getChildrenNumber() {
        return this.children.size();
    }

    public boolean addChild(Shape item) {
        if (item == null || this == item.getParent() && this.children.contains(item)) {
            return false;
        }
        item.setParent(this);
        return this.children.add(item);
    }

    public boolean removeChild(Shape item) {
        if (item == null) {
            return false;
        }
        item.setParent(null);
        return this.children.remove(item);
    }

    public void deleteChildren() {
        Iterator<Shape> it = this.getChildrenIterator();
        while (it.hasNext()) {
            Shape me = it.next();
            me.setParent(null);
        }
        this.children.clear();
    }

    public void sortChildren(boolean deepInto) {
        Collections.sort(this.children);
        if (deepInto) {
            Iterator<Shape> it = this.getChildrenIterator();
            while (it.hasNext()) {
                Shape me = it.next();
                me.sortChildren(deepInto);
            }
        }
    }

    public void cleanupSelection() {
        Iterator<Shape> it = this.getChildrenIterator();
        while (it.hasNext()) {
            Shape me = it.next();
            me.setSelected(false);
        }
        this.setSelected(false);
    }

    @Override
    public int compareTo(BaseElement be) {
        return this.toString().compareToIgnoreCase(be.toString());
    }

    public Object getEditableValue() {
        return this.toString();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return EMPTY_ARRAY;
    }

    public Object getPropertyValue(Object id) {
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        boolean selectedOld = this.selected;
        this.selected = selected;
        this.firePropertyChange(SELECTED, selectedOld, selected);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        boolean visibleOld = this.visible;
        this.visible = visible;
        this.setVisibleChildren(visible);
        this.firePropertyChange(VISIBLE, visibleOld, visible);
        this.updateVisibleValue(this.visible);
    }

    public void updateVisibleValue(boolean initState) {
        if (!this.visible) {
            this.setSelected(false);
        }
    }

    public boolean isVisibleChildren() {
        return this.visibleChildren;
    }

    public void setVisibleChildren(boolean visibleChildren) {
        boolean visibleChildrenOld = this.visibleChildren;
        this.visibleChildren = visibleChildren;
        if (visibleChildren && !this.visible) {
            this.setVisible(true);
        }
        Iterator<Shape> it = this.getChildrenIterator();
        while (it.hasNext()) {
            it.next().setVisible(visibleChildren);
        }
        this.firePropertyChange(VISIBLE_CHILDREN, visibleChildrenOld, visibleChildren);
    }

    public void refreshBasic() {
        this.firePropertyChange(REFRESH, null, null);
    }

    public void refresh() {
        Iterator<Shape> it = this.getChildrenIterator();
        while (it.hasNext()) {
            Shape shape = it.next();
            shape.refresh();
        }
        this.refreshBasic();
    }

    public abstract String getKey();

    public void setPrValue(IMemento memento, String propertyName, boolean value) {
        Utils.setPropertyValue(memento, String.valueOf(this.getKey()) + "." + propertyName, value);
    }

    public boolean getPrValue(IMemento memento, String propertyName, boolean def) {
        return Utils.getPropertyValue(memento, String.valueOf(this.getKey()) + "." + propertyName, def);
    }

    public void setPrValue(Properties properties, String propertyName, boolean value) {
        Utils.setPropertyValue(properties, String.valueOf(this.getKey()) + "." + propertyName, value);
    }

    public boolean getPrValue(Properties properties, String propertyName, boolean def) {
        return Utils.getPropertyValue(properties, String.valueOf(this.getKey()) + "." + propertyName, def);
    }

    public void setPrValue(IMemento memento, String propertyName, int value) {
        Utils.setPropertyValue(memento, String.valueOf(this.getKey()) + "." + propertyName, Integer.toString(value));
    }

    public int getPrValue(IMemento memento, String propertyName, int def) {
        return Utils.getPropertyValue(memento, String.valueOf(this.getKey()) + "." + propertyName, def);
    }

    public void setPrValue(Properties properties, String propertyName, int value) {
        Utils.setPropertyValue(properties, String.valueOf(this.getKey()) + "." + propertyName, Integer.toString(value));
    }

    public int getPrValue(Properties properties, String propertyName, int def) {
        return Utils.getPropertyValue(properties, String.valueOf(this.getKey()) + "." + propertyName, def);
    }

    public void setPrValue(IMemento memento, String propertyName, double value) {
        Utils.setPropertyValue(memento, String.valueOf(this.getKey()) + "." + propertyName, Double.toString(value));
    }

    public double getPrValue(IMemento memento, String propertyName, double def) {
        return Utils.getPropertyValue(memento, String.valueOf(this.getKey()) + "." + propertyName, def);
    }

    public void setPrValue(Properties properties, String propertyName, double value) {
        Utils.setPropertyValue(properties, String.valueOf(this.getKey()) + "." + propertyName, Double.toString(value));
    }

    public double getPrValue(Properties properties, String propertyName, double def) {
        return Utils.getPropertyValue(properties, String.valueOf(this.getKey()) + "." + propertyName, def);
    }

    public void setPrValue(IMemento memento, String propertyName, String value) {
        Utils.setPropertyValue(memento, String.valueOf(this.getKey()) + "." + propertyName, value);
    }

    public String getPrValue(IMemento memento, String propertyName, String def) {
        return Utils.getPropertyValue(memento, String.valueOf(this.getKey()) + "." + propertyName, def);
    }

    public void setPrValue(Properties properties, String propertyName, String value) {
        Utils.setPropertyValue(properties, String.valueOf(this.getKey()) + "." + propertyName, value);
    }

    public String getPrValue(Properties properties, String propertyName, String def) {
        return Utils.getPropertyValue(properties, String.valueOf(this.getKey()) + "." + propertyName, def);
    }

    public void loadState(IMemento memento) {
        boolean visibleChildren = this.getPrValue(memento, VISIBLE_CHILDREN, true);
        this.setVisibleChildren(visibleChildren);
        boolean visible = this.getPrValue(memento, VISIBLE, true);
        this.setVisible(visible);
        boolean selected = this.getPrValue(memento, SELECTED, true);
        this.setSelected(selected);
        Iterator<Shape> it = this.getChildrenIterator();
        while (it.hasNext()) {
            it.next().loadState(memento);
        }
    }

    protected void loadFromProperties(Properties properties) {
        boolean visibleChildren = this.getPrValue(properties, VISIBLE_CHILDREN, true);
        this.setVisibleChildren(visibleChildren);
        boolean visible = this.getPrValue(properties, VISIBLE, true);
        this.setVisible(visible);
        boolean selected = this.getPrValue(properties, SELECTED, true);
        this.setSelected(selected);
        Iterator<Shape> it = this.getChildrenIterator();
        while (it.hasNext()) {
            it.next().loadFromProperties(properties);
        }
    }

    public void saveState(IMemento memento) {
        String className = this.getClass().getCanonicalName();
        this.setPrValue(memento, CLASS_NAME, className);
        boolean visibleChildren = this.isVisibleChildren();
        this.setPrValue(memento, VISIBLE_CHILDREN, visibleChildren);
        boolean visible = this.isVisible();
        this.setPrValue(memento, VISIBLE, visible);
        boolean selected = this.isSelected();
        this.setPrValue(memento, SELECTED, selected);
        Iterator<Shape> it = this.getChildrenIterator();
        while (it.hasNext()) {
            it.next().saveState(memento);
        }
    }

    protected void saveInProperties(Properties properties) {
        String className = this.getClass().getCanonicalName();
        this.setPrValue(properties, CLASS_NAME, className);
        boolean visibleChildren = this.isVisibleChildren();
        this.setPrValue(properties, VISIBLE_CHILDREN, visibleChildren);
        boolean visible = this.isVisible();
        this.setPrValue(properties, VISIBLE, visible);
        boolean selected = this.isSelected();
        this.setPrValue(properties, SELECTED, selected);
        Iterator<Shape> it = this.getChildrenIterator();
        while (it.hasNext()) {
            it.next().saveInProperties(properties);
        }
    }

    protected Object toEmptyStr(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj;
    }
}

