/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.parts;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FocusBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.jboss.tools.hibernate.ui.diagram.editors.figures.ComponentFigure;
import org.jboss.tools.hibernate.ui.diagram.editors.model.BaseElement;
import org.jboss.tools.hibernate.ui.diagram.editors.model.ComponentShape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.ExpandableShape;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.ExpandableShapeEditPart;

public class ComponentShapeEditPart
extends ExpandableShapeEditPart {
    public ComponentFigure getComponentFigure() {
        if (this.getFigure() instanceof ComponentFigure) {
            return (ComponentFigure)this.getFigure();
        }
        return null;
    }

    protected IFigure createFigure() {
        ComponentFigure figure = new ComponentFigure();
        figure.createTitle(this.getOrmDiagram().getLabelProvider().getText(this.getElement()), this.getOrmDiagram().getLabelProvider().getImage(this.getElement()), this.getColor(), this.getOrmDiagram().getFontHeight());
        figure.setBorder((Border)new FocusBorder());
        figure.setSize(-1, -1);
        return figure;
    }

    public void activate() {
        super.activate();
    }

    public ComponentShape getModelComponentShape() {
        return (ComponentShape)this.getModel();
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType())) {
            ExpandableShape es = this.getModelExpandableShape();
            if (es.isExpanded()) {
                es.collapse();
            } else {
                es.expand();
            }
        } else {
            super.performRequest(req);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("expanded".equals(prop)) {
            BaseElement parent;
            boolean expanded = (Boolean)evt.getNewValue();
            if (this.getComponentFigure() != null) {
                this.getComponentFigure().setExpanded(expanded);
            }
            if ((parent = this.getModelParent()).getParent() != null) {
                parent.refreshBasic();
            }
            this.getOrmDiagram().updateDirty(evt.getNewValue() != evt.getOldValue());
        } else if ("refresh".equals(prop)) {
            if (this.getComponentFigure() != null) {
                this.getComponentFigure().setExpanded(this.getModelExpandableShape().isExpanded());
            }
            super.propertyChange(evt);
        } else {
            super.propertyChange(evt);
        }
        this.refresh();
    }

    protected void refreshVisuals() {
        Rectangle bounds = null;
        if (this.getModel() instanceof ComponentShape) {
            bounds = new Rectangle(new Point(0, 0), this.getFigure().getSize());
        }
        if (bounds != null) {
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), bounds);
        }
    }
}

