/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.jboss.tools.hibernate.ui.diagram.editors.figures.RoundPolylineConnection;
import org.jboss.tools.hibernate.ui.diagram.editors.model.BaseElement;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Connection;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.GEFRootEditPart;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.ResourceManager;

public class ConnectionEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener,
EditPartListener {
    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((BaseElement)this.getModel()).addPropertyChangeListener(this);
            this.addEditPartListener(this);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ShapesSelectionEditPolicy());
    }

    protected IFigure createFigure() {
        RoundPolylineConnection connection = new RoundPolylineConnection();
        connection.setForegroundColor(this.getColor());
        connection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        connection.setVisible(this.getModelConnection().isVisible());
        return connection;
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((BaseElement)this.getModel()).removePropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getPropertyName();
        if ("selected".equals(property)) {
            this.updateSelected((Boolean)event.getNewValue());
        } else if ("visible".equals(property)) {
            this.getFigure().setVisible(((Boolean)event.getNewValue()).booleanValue());
        } else if ("refresh".equals(property)) {
            this.getFigure().setVisible(this.getModelConnection().isVisible());
            this.updateSelected(this.getModelConnection().isSelected());
        }
    }

    protected void updateSelected(boolean selected) {
        if (!selected) {
            this.setSelected(0);
        }
        this.getFigure().setForegroundColor(selected ? this.getSelectionColor() : this.getColor());
    }

    private Connection getModelConnection() {
        return (Connection)this.getModel();
    }

    protected Object getTargetElement() {
        return this.getModelConnection().getTarget().getOrmElement();
    }

    private Color getColor() {
        Object el = this.getTargetElement();
        if (el instanceof RootClass || el instanceof Subclass) {
            return ResourceManager.getInstance().getColor(new RGB(210, 155, 100));
        }
        if (el instanceof Column || el instanceof Table || el instanceof Property) {
            return ResourceManager.getInstance().getColor(new RGB(160, 160, 160));
        }
        return ResourceManager.getInstance().getColor(new RGB(255, 0, 0));
    }

    private Color getSelectionColor() {
        Object el = this.getTargetElement();
        if (el instanceof RootClass || el instanceof Subclass) {
            return ResourceManager.getInstance().getColor(new RGB(112, 161, 99));
        }
        if (el instanceof Column || el instanceof Table || el instanceof Component) {
            return ResourceManager.getInstance().getColor(new RGB(66, 173, 247));
        }
        return ResourceManager.getInstance().getColor(new RGB(255, 0, 0));
    }

    public void childAdded(EditPart child, int index) {
    }

    public void partActivated(EditPart editpart) {
    }

    public void partDeactivated(EditPart editpart) {
    }

    public void removingChild(EditPart child, int index) {
    }

    public void selectedStateChanged(EditPart editpart) {
        if (this.getSelected() == 2) {
            ((GEFRootEditPart)this.getParent()).setToFront(this);
        }
    }

    private class ShapesSelectionEditPolicy
    extends SelectionEditPolicy {
        private ShapesSelectionEditPolicy() {
        }

        protected void hideSelection() {
            ConnectionEditPart.this.getModelConnection().setSelected(false);
        }

        protected void showSelection() {
            ConnectionEditPart.this.getModelConnection().setSelected(true);
        }
    }
}

