/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.parts;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ResourceManager {
    private Map<RGB, Color> fColorTable = new HashMap<RGB, Color>(10);
    private Map<FontData, Font> fFontTable = new HashMap<FontData, Font>(10);
    private static ResourceManager resourceManager = new ResourceManager();

    public static ResourceManager getInstance() {
        return resourceManager;
    }

    private ResourceManager() {
    }

    private void dispose() {
        Iterator<Color> e = this.fColorTable.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
        Iterator<Font> e2 = this.fFontTable.values().iterator();
        while (e2.hasNext()) {
            e2.next().dispose();
        }
    }

    public Color getColor(RGB rgb) {
        Color color = this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }

    public Font getFont(FontData fontData) {
        Font font = this.fFontTable.get(fontData);
        if (font == null) {
            font = new Font((Device)Display.getCurrent(), fontData);
            this.fFontTable.put(fontData, font);
        }
        return font;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }
}

