/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.parts;

import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.rulers.RulerProvider;
import org.jboss.tools.hibernate.ui.diagram.editors.command.ChangeGuideCommand;
import org.jboss.tools.hibernate.ui.diagram.editors.command.ShapeSetConstraintCommand;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.OrmShapeEditPart;
import org.jboss.tools.hibernate.ui.diagram.rulers.DiagramGuide;

public class ShapesXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    public ShapesXYLayoutEditPolicy(XYLayout layout) {
        this.setXyLayout(layout);
    }

    protected Command chainGuideAttachmentCommand(Request request, OrmShape part, Command cmd, boolean horizontal) {
        Command result = cmd;
        Integer guidePos = (Integer)request.getExtendedData().get(horizontal ? "SnapToGuides.HorizontalGuide" : "SnapToGuides.VerticalGuide");
        if (guidePos != null) {
            int alignment = (Integer)request.getExtendedData().get(horizontal ? "SnapToGuides.HorizontalAttachment" : "SnapToGuides.VerticalAttachment");
            ChangeGuideCommand cgm = new ChangeGuideCommand(part, horizontal);
            cgm.setNewGuide(this.findGuideAt(guidePos, horizontal), alignment);
            result = result.chain((Command)cgm);
        }
        return result;
    }

    protected DiagramGuide findGuideAt(int pos, boolean horizontal) {
        RulerProvider provider = (RulerProvider)this.getHost().getViewer().getProperty(horizontal ? "vertical ruler" : "horizontal ruler");
        return (DiagramGuide)provider.getGuideAt(pos);
    }

    protected Command chainGuideDetachmentCommand(Request request, OrmShape part, Command cmd, boolean horizontal) {
        Command result = cmd;
        Integer guidePos = (Integer)request.getExtendedData().get(horizontal ? "SnapToGuides.HorizontalGuide" : "SnapToGuides.VerticalGuide");
        if (guidePos == null) {
            result = result.chain((Command)new ChangeGuideCommand(part, horizontal));
        }
        return result;
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        int edgeBeingResized;
        int alignment;
        Integer guidePos;
        if (!(child instanceof OrmShapeEditPart) || !(constraint instanceof Rectangle)) {
            return super.createChangeConstraintCommand(request, child, constraint);
        }
        OrmShape part = (OrmShape)child.getModel();
        ShapeSetConstraintCommand result = new ShapeSetConstraintCommand(part, request, ((Rectangle)constraint).getLocation());
        if ((request.getResizeDirection() & 5) != 0) {
            guidePos = (Integer)request.getExtendedData().get("SnapToGuides.HorizontalGuide");
            if (guidePos != null) {
                result = this.chainGuideAttachmentCommand((Request)request, part, result, true);
            } else if (part.getHorizontalGuide() != null) {
                alignment = part.getHorizontalGuide().getAlignment(part);
                edgeBeingResized = 0;
                edgeBeingResized = (request.getResizeDirection() & 1) != 0 ? -1 : 1;
                if (alignment == edgeBeingResized) {
                    result = result.chain(new ChangeGuideCommand(part, true));
                }
            }
        }
        if ((request.getResizeDirection() & 0x18) != 0) {
            guidePos = (Integer)request.getExtendedData().get("SnapToGuides.VerticalGuide");
            if (guidePos != null) {
                result = this.chainGuideAttachmentCommand((Request)request, part, result, false);
            } else if (part.getVerticalGuide() != null) {
                alignment = part.getVerticalGuide().getAlignment(part);
                edgeBeingResized = 0;
                edgeBeingResized = (request.getResizeDirection() & 8) != 0 ? -1 : 1;
                if (alignment == edgeBeingResized) {
                    result = result.chain(new ChangeGuideCommand(part, false));
                }
            }
        }
        if (request.getType().equals("move children") || request.getType().equals("align children")) {
            result = this.chainGuideAttachmentCommand((Request)request, part, result, true);
            result = this.chainGuideAttachmentCommand((Request)request, part, result, false);
            result = this.chainGuideDetachmentCommand((Request)request, part, result, true);
            result = this.chainGuideDetachmentCommand((Request)request, part, result, false);
        }
        return result;
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new NonResizableEditPolicy();
    }
}

