/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.config.impl;

import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParserFactory;
import org.metawidget.config.iface.ConfigReader;
import org.metawidget.config.iface.NeedsResourceResolver;
import org.metawidget.config.iface.ResourceResolver;
import org.metawidget.config.impl.SimpleResourceResolver;
import org.metawidget.iface.Immutable;
import org.metawidget.iface.MetawidgetException;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.LogUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseConfigReader
implements ConfigReader {
    static final String IMMUTABLE_NO_CONFIG = "no-config";
    static final LogUtils.Log LOG = LogUtils.getLog(BaseConfigReader.class);
    static final String JAVA_NAMESPACE_PREFIX = "java:";
    protected final SAXParserFactory mFactory;
    private final ResourceResolver mResourceResolver;
    final Map<String, XmlUtils.CachingContentHandler> mResourceCache = CollectionUtils.newHashMap();
    final Map<String, Map<Integer, Immutable>> mImmutableByLocationCache = CollectionUtils.newHashMap();
    final Map<Class<?>, Map<Object, Immutable>> mImmutableByClassCache = CollectionUtils.newWeakHashMap();
    final Map<String, Immutable> mImmutableByIdCache = CollectionUtils.newHashMap();
    final Map<String, Pattern> mPatternCache = CollectionUtils.newHashMap();

    public BaseConfigReader() {
        this(new SimpleResourceResolver());
    }

    public BaseConfigReader(ResourceResolver resourceResolver) {
        this.mFactory = SAXParserFactory.newInstance();
        this.mFactory.setNamespaceAware(true);
        this.mResourceResolver = resourceResolver;
    }

    @Override
    public Object configure(String resource, Object toConfigure, String ... names) {
        ConfigHandler configHandler = new ConfigHandler(toConfigure, names);
        String locationKey = resource + StringUtils.SEPARATOR_FORWARD_SLASH;
        if (toConfigure instanceof Class) {
            locationKey = locationKey + ((Class)toConfigure).getName();
        } else if (toConfigure != null) {
            locationKey = locationKey + toConfigure.getClass().getName();
        }
        locationKey = locationKey + ArrayUtils.toString(names, StringUtils.SEPARATOR_FORWARD_SLASH, true, false);
        Map<String, Map<Integer, Immutable>> map = this.mImmutableByLocationCache;
        synchronized (map) {
            Map<Integer, Immutable> immutableByLocationCache = this.mImmutableByLocationCache.get(locationKey);
            if (immutableByLocationCache == null) {
                immutableByLocationCache = CollectionUtils.newHashMap();
            }
            configHandler.setImmutableForThisLocationCache(immutableByLocationCache);
            try {
                XmlUtils.CachingContentHandler cachingContentHandler = this.mResourceCache.get(locationKey);
                if (cachingContentHandler != null) {
                    cachingContentHandler.replay(configHandler);
                } else {
                    LOG.debug("Reading resource from {0}", locationKey);
                    cachingContentHandler = new XmlUtils.CachingContentHandler(configHandler);
                    configHandler.setCachingContentHandler(cachingContentHandler);
                    this.mFactory.newSAXParser().parse(this.mResourceResolver.openResource(resource), (DefaultHandler)cachingContentHandler);
                    this.mResourceCache.put(locationKey, cachingContentHandler);
                    this.mImmutableByLocationCache.put(locationKey, immutableByLocationCache);
                }
                return configHandler.getConfigured();
            }
            catch (Exception e) {
                throw MetawidgetException.newException(e);
            }
        }
    }

    @Override
    public Object configure(InputStream stream, Object toConfigure, String ... names) {
        if (stream == null) {
            throw MetawidgetException.newException("No input stream specified");
        }
        try {
            ConfigHandler configHandler = new ConfigHandler(toConfigure, names);
            this.mFactory.newSAXParser().parse(stream, (DefaultHandler)configHandler);
            return configHandler.getConfigured();
        }
        catch (Exception e) {
            throw MetawidgetException.newException(e);
        }
    }

    public final ResourceResolver getResourceResolver() {
        return this.mResourceResolver;
    }

    protected boolean isNative(String name) {
        if ("null".equals(name)) {
            return true;
        }
        if ("string".equals(name)) {
            return true;
        }
        if ("class".equals(name)) {
            return true;
        }
        if ("instanceOf".equals(name)) {
            return true;
        }
        if ("pattern".equals(name)) {
            return true;
        }
        if ("format".equals(name)) {
            return true;
        }
        if ("int".equals(name)) {
            return true;
        }
        if ("boolean".equals(name)) {
            return true;
        }
        if ("resource".equals(name)) {
            return true;
        }
        if ("url".equals(name)) {
            return true;
        }
        if ("file".equals(name)) {
            return true;
        }
        if ("bundle".equals(name)) {
            return true;
        }
        return "constant".equals(name);
    }

    protected boolean isLazyResolvingNative(String name) {
        return "enum".equals(name);
    }

    protected Object createNative(String name, Class<?> namespace, String recordedText) throws Exception {
        if ("null".equals(name)) {
            return null;
        }
        if ("string".equals(name)) {
            return recordedText;
        }
        if ("class".equals(name)) {
            if ("".equals(recordedText)) {
                return null;
            }
            return Class.forName(recordedText);
        }
        if ("instanceOf".equals(name)) {
            if ("".equals(recordedText)) {
                return null;
            }
            return Class.forName(recordedText).newInstance();
        }
        if ("pattern".equals(name)) {
            Pattern pattern = this.mPatternCache.get(recordedText);
            if (pattern == null) {
                pattern = Pattern.compile(recordedText);
                this.mPatternCache.put(recordedText, pattern);
            }
            return pattern;
        }
        if ("format".equals(name)) {
            return new MessageFormat(recordedText);
        }
        if ("int".equals(name)) {
            return Integer.valueOf(recordedText);
        }
        if ("boolean".equals(name)) {
            return Boolean.valueOf(recordedText);
        }
        if ("bundle".equals(name)) {
            return ResourceBundle.getBundle(recordedText);
        }
        if ("enum".equals(name)) {
            return recordedText;
        }
        if ("constant".equals(name)) {
            int lastIndexOf = recordedText.lastIndexOf(46);
            if (lastIndexOf != -1) {
                return Class.forName(recordedText.substring(0, lastIndexOf)).getDeclaredField(recordedText.substring(lastIndexOf + 1)).get(null);
            }
            return namespace.getDeclaredField(recordedText).get(null);
        }
        if ("resource".equals(name)) {
            return this.mResourceResolver.openResource(recordedText);
        }
        if ("url".equals(name)) {
            return new URL(recordedText).openStream();
        }
        if ("file".equals(name)) {
            return new FileInputStream(recordedText);
        }
        throw MetawidgetException.newException("Don't know how to convert '" + recordedText + "' to a " + name);
    }

    protected Object createNativeCollection(String name) {
        if ("array".equals(name)) {
            return new Object[0];
        }
        if ("list".equals(name)) {
            return CollectionUtils.newArrayList();
        }
        if ("set".equals(name)) {
            return CollectionUtils.newHashSet();
        }
        return null;
    }

    protected Object createLazyResolvingNative(Object nativeValue, Class<?> toResolveTo) {
        if (toResolveTo.isArray() && nativeValue.getClass().isArray()) {
            Object[] array = (Object[])nativeValue;
            Object[] compatibleArray = (Object[])Array.newInstance(toResolveTo.getComponentType(), array.length);
            try {
                System.arraycopy(array, 0, compatibleArray, 0, array.length);
                return compatibleArray;
            }
            catch (ArrayStoreException e) {
                return null;
            }
        }
        if (toResolveTo.isEnum() && nativeValue instanceof String) {
            try {
                Object enumValue = Enum.valueOf(toResolveTo, (String)nativeValue);
                return enumValue;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    protected Class<?> lookupClass(String uri, String localName, ClassLoader classLoader) throws SAXException {
        String innerClassToConstruct;
        if (!uri.startsWith(JAVA_NAMESPACE_PREFIX)) {
            throw new SAXException("Namespace '" + uri + "' of element <" + localName + "> must start with " + JAVA_NAMESPACE_PREFIX);
        }
        String packagePrefix = uri.substring(JAVA_NAMESPACE_PREFIX.length());
        String uppercasedLocalName = StringUtils.capitalize(localName);
        String classToConstruct = packagePrefix + '.' + uppercasedLocalName;
        Class<?> clazz = this.lookupClass(classToConstruct, classLoader);
        if (clazz == null && (clazz = this.lookupClass(innerClassToConstruct = packagePrefix + '$' + uppercasedLocalName, classLoader)) == null) {
            throw MetawidgetException.newException("No such tag <" + localName + "> or class " + classToConstruct + " (is it on your CLASSPATH?)");
        }
        return clazz;
    }

    protected Class<?> lookupClass(String className, ClassLoader classLoader) {
        return ClassUtils.niceForName(className, classLoader);
    }

    protected boolean isImmutable(Class<?> clazz) {
        return Immutable.class.isAssignableFrom(clazz);
    }

    private static class ConfigAndId {
        private Object mConfig;
        private String mId;

        public ConfigAndId(Object config, String id) {
            this.mConfig = config;
            this.mId = id;
        }

        public Object getConfig() {
            return this.mConfig;
        }

        public String getId() {
            return this.mId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigHandler
    extends DefaultHandler {
        private Object mToConfigure;
        private String[] mNames;
        private int mLocationIndex;
        private Map<Integer, Immutable> mImmutableForThisLocationCache;
        private int mDepth;
        private int mIgnoreTypeAfterDepth = -1;
        private int mIgnoreNameAfterDepth = -1;
        private int mIgnoreImmutableAfterDepth = -1;
        private Stack<Object> mConstructing = CollectionUtils.newStack();
        private ExpectingState mExpecting = ExpectingState.ROOT;
        private Stack<EncounteredState> mEncountered = CollectionUtils.newStack();
        private StringBuilder mBuilderValue;
        private XmlUtils.CachingContentHandler mCachingContentHandler;

        public ConfigHandler(Object toConfigure, String ... names) {
            this.mToConfigure = toConfigure;
            this.mNames = names;
        }

        public void setImmutableForThisLocationCache(Map<Integer, Immutable> immutableForThisLocationCache) {
            this.mImmutableForThisLocationCache = immutableForThisLocationCache;
        }

        public void setCachingContentHandler(XmlUtils.CachingContentHandler cachingContentHandler) {
            this.mCachingContentHandler = cachingContentHandler;
        }

        public Object getConfigured() {
            if (this.mConstructing.isEmpty()) {
                if (this.mToConfigure instanceof Class) {
                    throw MetawidgetException.newException("No match for " + this.mToConfigure + " within config");
                }
                throw MetawidgetException.newException("No match for " + this.mToConfigure.getClass() + " within config");
            }
            if (this.mConstructing.size() > 1) {
                throw MetawidgetException.newException("Config still processing");
            }
            return this.mConstructing.peek();
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            ++this.mDepth;
            if (this.mIgnoreTypeAfterDepth != -1 && this.mDepth > this.mIgnoreTypeAfterDepth) {
                return;
            }
            if (this.mIgnoreNameAfterDepth != -1 && this.mDepth > this.mIgnoreNameAfterDepth) {
                return;
            }
            if (Character.isUpperCase(localName.charAt(0))) {
                throw MetawidgetException.newException("XML node '" + localName + "' should start with a lowercase letter");
            }
            try {
                switch (this.mExpecting) {
                    case ROOT: {
                        if (this.mToConfigure == null) {
                            this.mExpecting = ExpectingState.OBJECT;
                            break;
                        }
                        this.mExpecting = ExpectingState.TO_CONFIGURE;
                        break;
                    }
                    case TO_CONFIGURE: {
                        if (this.mDepth != 2) {
                            return;
                        }
                        Class<?> toConfigureClass = BaseConfigReader.this.lookupClass(uri, localName, this.mToConfigure.getClass().getClassLoader());
                        if (this.mToConfigure instanceof Class) {
                            if (!((Class)this.mToConfigure).isAssignableFrom(toConfigureClass)) {
                                this.mEncountered.push(EncounteredState.WRONG_TYPE);
                                this.mIgnoreTypeAfterDepth = 2;
                                if (this.mCachingContentHandler != null) {
                                    this.mCachingContentHandler.pause(false);
                                }
                                return;
                            }
                            if (!this.mConstructing.isEmpty()) {
                                throw MetawidgetException.newException("Already configured a " + this.mConstructing.peek().getClass() + ", ambiguous match with " + toConfigureClass);
                            }
                            this.handleNonNativeObject(uri, localName, attributes);
                        } else {
                            if (!this.mConstructing.isEmpty() || !toConfigureClass.isAssignableFrom(this.mToConfigure.getClass())) {
                                this.mEncountered.push(EncounteredState.WRONG_TYPE);
                                this.mIgnoreTypeAfterDepth = 2;
                                if (this.mCachingContentHandler != null) {
                                    this.mCachingContentHandler.pause(false);
                                }
                                return;
                            }
                            this.mConstructing.push(this.mToConfigure);
                            this.mEncountered.push(EncounteredState.JAVA_OBJECT);
                        }
                        this.mExpecting = ExpectingState.METHOD;
                        break;
                    }
                    case OBJECT: {
                        if (this.mCachingContentHandler == null || !this.mCachingContentHandler.isPaused()) {
                            ++this.mLocationIndex;
                        }
                        if (BaseConfigReader.this.isNative(localName) || BaseConfigReader.this.isLazyResolvingNative(localName)) {
                            this.mEncountered.push(EncounteredState.NATIVE_TYPE);
                            this.startRecording();
                            this.mExpecting = ExpectingState.METHOD;
                            return;
                        }
                        Object collection = BaseConfigReader.this.createNativeCollection(localName);
                        if (collection != null) {
                            this.mConstructing.push(collection);
                            this.mEncountered.push(EncounteredState.NATIVE_COLLECTION_TYPE);
                            this.mExpecting = ExpectingState.OBJECT;
                            return;
                        }
                        this.mExpecting = this.handleNonNativeObject(uri, localName, attributes);
                        break;
                    }
                    case METHOD: {
                        String expectingName;
                        int nameIndex;
                        if (this.mNames != null && (nameIndex = this.mDepth - 3) < this.mNames.length && !localName.equals(expectingName = this.mNames[nameIndex])) {
                            this.mEncountered.push(EncounteredState.WRONG_NAME);
                            this.mIgnoreNameAfterDepth = this.mDepth;
                            if (this.mCachingContentHandler != null) {
                                this.mCachingContentHandler.pause(false);
                            }
                            return;
                        }
                        this.mConstructing.push(new ArrayList());
                        this.mEncountered.push(EncounteredState.METHOD);
                        this.mExpecting = ExpectingState.OBJECT;
                        break;
                    }
                    case CLOSE_OBJECT_WITH_REFID: {
                        throw InspectorException.newException("<" + name + "> not expected here. Elements with a 'refId' must have an empty body");
                    }
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        public void startRecording() {
            this.mBuilderValue = new StringBuilder();
        }

        @Override
        public void characters(char[] characters, int start, int length) {
            if (this.mBuilderValue == null) {
                return;
            }
            this.mBuilderValue.append(characters, start, length);
        }

        public String endRecording() {
            String value = this.mBuilderValue.toString();
            this.mBuilderValue = null;
            return value;
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            --this.mDepth;
            if (this.mIgnoreTypeAfterDepth != -1) {
                if (this.mDepth >= this.mIgnoreTypeAfterDepth) {
                    return;
                }
                this.mIgnoreTypeAfterDepth = -1;
                if (this.mCachingContentHandler != null) {
                    this.mCachingContentHandler.unpause(false);
                }
            }
            if (this.mIgnoreNameAfterDepth != -1) {
                if (this.mDepth >= this.mIgnoreNameAfterDepth) {
                    return;
                }
                this.mIgnoreNameAfterDepth = -1;
                if (this.mCachingContentHandler != null) {
                    this.mCachingContentHandler.unpause(false);
                }
            }
            if (this.mDepth == 0) {
                return;
            }
            if (this.mConstructing.isEmpty()) {
                return;
            }
            try {
                EncounteredState encountered = this.mEncountered.pop();
                switch (encountered) {
                    case NATIVE_TYPE: {
                        Object methodParameters = this.mConstructing.pop();
                        Object constructing = this.mConstructing.peek();
                        if (constructing instanceof ConfigAndId) {
                            constructing = ((ConfigAndId)this.mConstructing.peek()).getConfig();
                        }
                        this.mConstructing.push(methodParameters);
                        this.addToConstructing(BaseConfigReader.this.createNative(localName, constructing.getClass(), this.endRecording()));
                        this.mExpecting = ExpectingState.OBJECT;
                        return;
                    }
                    case NATIVE_COLLECTION_TYPE: {
                        Object nativeCollectionType = this.mConstructing.pop();
                        Collection parameters = (Collection)this.mConstructing.peek();
                        parameters.add(nativeCollectionType);
                        this.mExpecting = ExpectingState.OBJECT;
                        return;
                    }
                    case CONFIGURED_TYPE: 
                    case JAVA_OBJECT: {
                        Object object = this.mConstructing.pop();
                        if (encountered == EncounteredState.CONFIGURED_TYPE) {
                            Class<?> classToConstruct = BaseConfigReader.this.lookupClass(uri, localName, this.mToConfigure.getClass().getClassLoader());
                            String id = ((ConfigAndId)object).getId();
                            object = ((ConfigAndId)object).getConfig();
                            Object configuredObject = null;
                            if (BaseConfigReader.this.isImmutable(classToConstruct)) {
                                configuredObject = this.getImmutableByClass(classToConstruct, object);
                            }
                            if (configuredObject == null) {
                                try {
                                    Constructor<?> constructor = classToConstruct.getConstructor(object.getClass());
                                    configuredObject = constructor.newInstance(object);
                                }
                                catch (NoSuchMethodException e) {
                                    String likelyConfig = this.getLikelyConfig(classToConstruct);
                                    if ("".equals(likelyConfig)) {
                                        throw MetawidgetException.newException(classToConstruct + " does not have a constructor that takes a " + object.getClass() + ", as specified by your config attribute. It only has a config-less constructor");
                                    }
                                    if (likelyConfig != null) {
                                        throw MetawidgetException.newException(classToConstruct + " does not have a constructor that takes a " + object.getClass() + ", as specified by your config attribute. Did you mean config=\"" + likelyConfig + "\"?");
                                    }
                                    throw MetawidgetException.newException(classToConstruct + " does not have a constructor that takes a " + object.getClass() + ", as specified by your config attribute");
                                }
                                if (BaseConfigReader.this.isImmutable(classToConstruct)) {
                                    LOG.debug("\tInstantiated immutable {0} (config hashCode {1})", classToConstruct, object.hashCode());
                                    Immutable immutable = (Immutable)configuredObject;
                                    this.putImmutableByClass(immutable, object);
                                    if (id != null) {
                                        this.putImmutableById(id, immutable);
                                    }
                                }
                            } else if (BaseConfigReader.this.isImmutable(classToConstruct) && this.mCachingContentHandler != null && this.mDepth < this.mIgnoreImmutableAfterDepth) {
                                this.mCachingContentHandler.unpause(true);
                                this.mIgnoreImmutableAfterDepth = -1;
                                this.putImmutableByLocation((Immutable)configuredObject);
                            }
                            object = configuredObject;
                        }
                        if (this.mDepth == 1) {
                            this.mConstructing.push(object);
                            this.mExpecting = ExpectingState.TO_CONFIGURE;
                            return;
                        }
                        this.addToConstructing(object);
                        this.mExpecting = ExpectingState.OBJECT;
                        return;
                    }
                    case METHOD: {
                        List parameters = (List)this.mConstructing.pop();
                        Object constructing = this.mConstructing.peek();
                        if (constructing instanceof ConfigAndId) {
                            constructing = ((ConfigAndId)constructing).getConfig();
                        }
                        Class<?> constructingClass = constructing.getClass();
                        String methodName = "set" + StringUtils.capitalize(localName);
                        try {
                            Method method = this.classGetMethod(constructingClass, methodName, parameters);
                            method.invoke(constructing, parameters.toArray());
                        }
                        catch (NoSuchMethodException e) {
                            for (Constructor<?> constructor : constructingClass.getConstructors()) {
                                String parameterClassName;
                                Class<?>[] parameterTypes = constructor.getParameterTypes();
                                if (parameterTypes.length != 1 || !(parameterClassName = parameterTypes[0].getClass().getSimpleName()).endsWith("Config")) continue;
                                throw MetawidgetException.newException("No such method " + methodName + " on " + constructingClass + ". Did you forget config=\"" + parameterClassName + "\"?");
                            }
                            throw e;
                        }
                        this.mExpecting = ExpectingState.METHOD;
                        return;
                    }
                    case WRONG_TYPE: {
                        return;
                    }
                    case WRONG_NAME: {
                        return;
                    }
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException) {
                    Throwable t = ((InvocationTargetException)e).getTargetException();
                    if (!(t instanceof Exception)) {
                        throw new RuntimeException(t);
                    }
                    e = (Exception)t;
                }
                throw new SAXException(e);
            }
        }

        @Override
        public void warning(SAXParseException exception) {
            LOG.warn(exception.getMessage(), new Object[0]);
        }

        @Override
        public void error(SAXParseException exception) {
            throw MetawidgetException.newException(exception);
        }

        private ExpectingState handleNonNativeObject(String uri, String localName, Attributes attributes) throws Exception {
            String refId = attributes.getValue("refId");
            String configClassName = attributes.getValue("config");
            if (refId != null) {
                if (configClassName != null) {
                    throw InspectorException.newException("Elements with 'refId' attributes (refId=\"" + refId + "\") cannot also have 'config' attributes (config=\"" + configClassName + "\")");
                }
                Object immutable = this.getImmutableByRefId(refId);
                Class<?> actualClass = immutable.getClass();
                if (!StringUtils.decapitalize(actualClass.getSimpleName()).equals(localName)) {
                    throw InspectorException.newException("refId=\"" + refId + "\" points to an object of " + actualClass + ", not a <" + localName + ">");
                }
                this.mConstructing.push(immutable);
                this.mEncountered.push(EncounteredState.JAVA_OBJECT);
                return ExpectingState.CLOSE_OBJECT_WITH_REFID;
            }
            Object object = null;
            Class<?> classToConstruct = BaseConfigReader.this.lookupClass(uri, localName, this.mToConfigure.getClass().getClassLoader());
            if (BaseConfigReader.this.isImmutable(classToConstruct)) {
                object = this.getImmutableByLocation();
            }
            if (object == null && configClassName != null) {
                String configToConstruct = configClassName.indexOf(46) == -1 ? classToConstruct.getPackage().getName() + '.' + configClassName : configClassName;
                Class<?> configClass = BaseConfigReader.this.lookupClass(configToConstruct, this.mToConfigure.getClass().getClassLoader());
                if (configClass == null) {
                    throw MetawidgetException.newException("No such configuration class " + configToConstruct);
                }
                Object config = configClass.newInstance();
                if (config instanceof NeedsResourceResolver) {
                    ((NeedsResourceResolver)config).setResourceResolver(BaseConfigReader.this.getResourceResolver());
                }
                this.mConstructing.push(new ConfigAndId(config, attributes.getValue("id")));
                this.mEncountered.push(EncounteredState.CONFIGURED_TYPE);
                if (this.mIgnoreImmutableAfterDepth == -1 && this.mCachingContentHandler != null && BaseConfigReader.this.isImmutable(classToConstruct)) {
                    this.mCachingContentHandler.pause(true);
                    this.mIgnoreImmutableAfterDepth = this.mDepth;
                }
                return ExpectingState.METHOD;
            }
            if (object == null && BaseConfigReader.this.isImmutable(classToConstruct)) {
                object = this.getImmutableByClass(classToConstruct, BaseConfigReader.IMMUTABLE_NO_CONFIG);
            }
            if (object == null) {
                try {
                    Constructor<?> defaultConstructor = classToConstruct.getConstructor(new Class[0]);
                    object = defaultConstructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    String likelyConfig = this.getLikelyConfig(classToConstruct);
                    if (likelyConfig != null) {
                        throw MetawidgetException.newException(classToConstruct + " does not have a default constructor. Did you mean config=\"" + likelyConfig + "\"?");
                    }
                    throw MetawidgetException.newException(classToConstruct + " does not have a default constructor");
                }
                if (BaseConfigReader.this.isImmutable(classToConstruct)) {
                    LOG.debug("\tInstantiated immutable {0} (no config)", classToConstruct);
                    Immutable immutable = (Immutable)object;
                    this.putImmutableByClass(immutable, null);
                    String id = attributes.getValue("id");
                    if (id != null) {
                        this.putImmutableById(id, immutable);
                    }
                }
            }
            this.mConstructing.push(object);
            this.mEncountered.push(EncounteredState.JAVA_OBJECT);
            return ExpectingState.METHOD;
        }

        private void addToConstructing(Object toAdd) {
            Object parameters = this.mConstructing.peek();
            if (parameters instanceof Collection) {
                Collection collection = (Collection)parameters;
                collection.add(toAdd);
                return;
            }
            if (parameters.getClass().isArray()) {
                Object[] array = (Object[])this.mConstructing.pop();
                Object[] newArray = new Object[array.length + 1];
                System.arraycopy(array, 0, newArray, 0, array.length);
                newArray[array.length] = toAdd;
                this.mConstructing.push(newArray);
                return;
            }
            throw MetawidgetException.newException("Don't know how to add to a " + parameters.getClass());
        }

        private Object getImmutableByLocation() {
            if (this.mImmutableForThisLocationCache == null) {
                return null;
            }
            return this.mImmutableForThisLocationCache.get(this.mLocationIndex);
        }

        private void putImmutableByLocation(Immutable immutable) {
            if (this.mImmutableForThisLocationCache == null) {
                return;
            }
            if (this.mImmutableForThisLocationCache.containsKey(this.mLocationIndex)) {
                throw InspectorException.newException("Location " + this.mLocationIndex + " already cached");
            }
            this.mImmutableForThisLocationCache.put(this.mLocationIndex, immutable);
        }

        private Object getImmutableByRefId(String refId) {
            if (!BaseConfigReader.this.mImmutableByIdCache.containsKey(refId)) {
                throw InspectorException.newException("Attribute refId=\"" + refId + "\" refers to non-existent id");
            }
            return BaseConfigReader.this.mImmutableByIdCache.get(refId);
        }

        private void putImmutableById(String id, Immutable immutable) {
            if (BaseConfigReader.this.mImmutableByIdCache.containsKey(id)) {
                throw InspectorException.newException("Attribute id=\"" + id + "\" appears more than once");
            }
            BaseConfigReader.this.mImmutableByIdCache.put(id, immutable);
        }

        private Object getImmutableByClass(Class<?> clazz, Object config) {
            Map<Object, Immutable> configs = BaseConfigReader.this.mImmutableByClassCache.get(clazz);
            if (configs == null) {
                return null;
            }
            Object configToLookup = config;
            if (configToLookup == null) {
                configToLookup = BaseConfigReader.IMMUTABLE_NO_CONFIG;
            }
            return configs.get(configToLookup);
        }

        private void putImmutableByClass(Immutable immutable, Object config) {
            Object configToStoreUnder;
            Map<Object, Immutable> configs;
            block15: {
                Class<?> clazz = immutable.getClass();
                configs = BaseConfigReader.this.mImmutableByClassCache.get(clazz);
                if (configs == null) {
                    configs = CollectionUtils.newHashMap();
                    BaseConfigReader.this.mImmutableByClassCache.put(clazz, configs);
                }
                if ((configToStoreUnder = config) == null) {
                    configToStoreUnder = BaseConfigReader.IMMUTABLE_NO_CONFIG;
                } else {
                    try {
                        Class<?> configClass = configToStoreUnder.getClass();
                        Class<?> equalsDeclaringClass = configClass.getMethod("equals", Object.class).getDeclaringClass();
                        if (Object.class.equals(equalsDeclaringClass)) {
                            throw MetawidgetException.newException(configClass + " does not override .equals(), so cannot cache reliably");
                        }
                        Class<?> hashCodeDeclaringClass = configClass.getMethod("hashCode", new Class[0]).getDeclaringClass();
                        if (Object.class.equals(hashCodeDeclaringClass)) {
                            throw MetawidgetException.newException(configClass + " does not override .hashCode(), so cannot cache reliably");
                        }
                        if (System.identityHashCode(configToStoreUnder) == configToStoreUnder.hashCode()) {
                            LOG.warn("{0} overrides .hashCode(), but it returns the same as System.identityHashCode, so cannot be cached reliably", configClass);
                        }
                        if (!equalsDeclaringClass.equals(hashCodeDeclaringClass)) {
                            throw MetawidgetException.newException(equalsDeclaringClass + " implements .equals(), but .hashCode() is implemented by " + hashCodeDeclaringClass + ", so cannot cache reliably");
                        }
                        if (configClass.equals(equalsDeclaringClass)) break block15;
                        for (Method declaredMethod : configClass.getMethods()) {
                            if (!configClass.equals(declaredMethod.getDeclaringClass())) continue;
                            for (Method equalsDeclaredMethod : equalsDeclaringClass.getMethods()) {
                                if (!equalsDeclaredMethod.getName().equals(declaredMethod.getName())) {
                                    continue;
                                }
                                break block15;
                            }
                            LOG.warn("{0} does not override .equals() (only its super{1} does), so may not be cached reliably", configClass, equalsDeclaringClass);
                            break;
                        }
                    }
                    catch (Exception e) {
                        throw MetawidgetException.newException(e);
                    }
                }
            }
            if (configs.containsKey(configToStoreUnder)) {
                throw InspectorException.newException("Config '" + configToStoreUnder + "' already cached");
            }
            configs.put(configToStoreUnder, immutable);
            if (this.mCachingContentHandler != null && this.mDepth < this.mIgnoreImmutableAfterDepth) {
                this.mCachingContentHandler.unpause(true);
                this.mIgnoreImmutableAfterDepth = -1;
                if (config != null) {
                    this.putImmutableByLocation(immutable);
                }
            }
        }

        private Method classGetMethod(Class<?> clazz, String name, List<Object> args) throws NoSuchMethodException {
            int numberOfParameterTypes = args.size();
            Method likelyMatch = null;
            block0: for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(name)) continue;
                likelyMatch = method;
                Class<?>[] methodParameterTypes = method.getParameterTypes();
                if (methodParameterTypes.length != numberOfParameterTypes) continue;
                ArrayList<Object> compatibleArgs = CollectionUtils.newArrayList(args);
                for (int loop = 0; loop < numberOfParameterTypes; ++loop) {
                    Object arg = compatibleArgs.get(loop);
                    Class<?> parameterType = methodParameterTypes[loop];
                    if (parameterType.isPrimitive()) {
                        parameterType = ClassUtils.getWrapperClass(parameterType);
                    } else if (arg == null) continue;
                    if (parameterType.isInstance(arg)) continue;
                    Object resolvedValue = BaseConfigReader.this.createLazyResolvingNative(arg, parameterType);
                    if (resolvedValue == null) continue block0;
                    compatibleArgs.remove(loop);
                    compatibleArgs.add(loop, resolvedValue);
                }
                args.clear();
                args.addAll(compatibleArgs);
                return method;
            }
            if (likelyMatch != null) {
                throw new NoSuchMethodException(this.methodToString(clazz, name, args) + ". Did you mean " + this.methodToString(likelyMatch) + "?");
            }
            throw new NoSuchMethodException(this.methodToString(clazz, name, args));
        }

        private String getLikelyConfig(Class<?> clazz) {
            Constructor<?>[] constructors = clazz.getConstructors();
            if (constructors.length != 1) {
                return null;
            }
            if (constructors[0].getParameterTypes().length == 0) {
                return "";
            }
            if (constructors[0].getParameterTypes().length > 1) {
                return null;
            }
            Class<?> likelyConfigClass = constructors[0].getParameterTypes()[0];
            if (likelyConfigClass.getPackage().equals(clazz.getPackage())) {
                return likelyConfigClass.getSimpleName();
            }
            return likelyConfigClass.getName();
        }

        private String methodToString(Method method) {
            StringBuilder builder = new StringBuilder();
            for (Class<?> parameterType : method.getParameterTypes()) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                if (parameterType.isArray()) {
                    builder.append(parameterType.getComponentType().getSimpleName());
                    builder.append("[]");
                    continue;
                }
                builder.append(parameterType.getSimpleName());
            }
            builder.insert(0, "(");
            builder.insert(0, method.getName());
            builder.append(")");
            return builder.toString();
        }

        private String methodToString(Class<?> clazz, String methodName, List<Object> args) {
            StringBuilder builder = new StringBuilder();
            for (Object obj : args) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                if (obj == null) {
                    builder.append("null");
                    continue;
                }
                builder.append(obj.getClass().getSimpleName());
            }
            builder.insert(0, "(");
            builder.insert(0, methodName);
            builder.insert(0, '.');
            builder.insert(0, clazz);
            builder.append(")");
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExpectingState {
        ROOT,
        TO_CONFIGURE,
        OBJECT,
        METHOD,
        CLOSE_OBJECT_WITH_REFID;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EncounteredState {
        METHOD,
        NATIVE_TYPE,
        NATIVE_COLLECTION_TYPE,
        CONFIGURED_TYPE,
        JAVA_OBJECT,
        WRONG_TYPE,
        WRONG_NAME;

    }
}

