/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.propertystyle.javabean;

import java.text.MessageFormat;
import org.metawidget.inspector.impl.BaseTraitStyleConfig;
import org.metawidget.util.simple.ObjectUtils;

public class JavaBeanPropertyStyleConfig
extends BaseTraitStyleConfig {
    private static String[] DEFAULT_EXCLUDE_NAME = new String[]{"propertyChangeListeners", "vetoableChangeListeners"};
    private boolean mNullExcludeName;
    private boolean mSupportPublicFields;
    private MessageFormat mPrivateFieldConvention;

    public JavaBeanPropertyStyleConfig setExcludeName(String ... excludeName) {
        super.setExcludeName(excludeName);
        this.mNullExcludeName = excludeName == null;
        return this;
    }

    public JavaBeanPropertyStyleConfig setSupportPublicFields(boolean supportPublicFields) {
        this.mSupportPublicFields = supportPublicFields;
        return this;
    }

    public JavaBeanPropertyStyleConfig setPrivateFieldConvention(MessageFormat privateFieldConvention) {
        this.mPrivateFieldConvention = privateFieldConvention;
        return this;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!ObjectUtils.nullSafeClassEquals(this, that)) {
            return false;
        }
        if (this.mNullExcludeName != ((JavaBeanPropertyStyleConfig)that).mNullExcludeName) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mPrivateFieldConvention, ((JavaBeanPropertyStyleConfig)that).mPrivateFieldConvention)) {
            return false;
        }
        if (this.mSupportPublicFields != ((JavaBeanPropertyStyleConfig)that).mSupportPublicFields) {
            return false;
        }
        return super.equals(that);
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mNullExcludeName);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mPrivateFieldConvention);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mSupportPublicFields);
        return hashCode;
    }

    protected String[] getExcludeName() {
        String[] excludeName = super.getExcludeName();
        if (excludeName == null && !this.mNullExcludeName) {
            return DEFAULT_EXCLUDE_NAME;
        }
        return excludeName;
    }

    protected boolean isSupportPublicFields() {
        return this.mSupportPublicFields;
    }

    protected MessageFormat getPrivateFieldConvention() {
        return this.mPrivateFieldConvention;
    }
}

