/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.statically.faces;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StaticFacesUtils {
    private static final Pattern PATTERN_EXPRESSION = Pattern.compile("(#|\\$)\\{([^\\}]+)\\}");
    private static final String EXPRESSION_START = "#{";
    private static final String EXPRESSION_END = "}";

    public static boolean isExpression(String value) {
        return StaticFacesUtils.matchExpression(value).matches();
    }

    public static Matcher matchExpression(String value) {
        return PATTERN_EXPRESSION.matcher(value);
    }

    public static String unwrapExpression(String value) {
        Matcher matcher = PATTERN_EXPRESSION.matcher(value);
        if (!matcher.matches()) {
            return value;
        }
        return matcher.group(2);
    }

    public static String wrapExpression(String value) {
        if (StaticFacesUtils.isExpression(value)) {
            return value;
        }
        return EXPRESSION_START + StaticFacesUtils.unwrapExpression(value) + EXPRESSION_END;
    }

    private StaticFacesUtils() {
    }
}

