/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.widgetbuilder.composite;

import java.util.Map;
import org.metawidget.widgetbuilder.composite.CompositeWidgetBuilderConfig;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetbuilder.iface.WidgetBuilderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeWidgetBuilder<W, M extends W>
implements WidgetBuilder<W, M> {
    final WidgetBuilder<W, M>[] mWidgetBuilders;

    public CompositeWidgetBuilder(CompositeWidgetBuilderConfig<W, M> config) {
        WidgetBuilder<W, M>[] widgetBuilders = config.getWidgetBuilders();
        if (widgetBuilders == null || widgetBuilders.length < 2) {
            throw WidgetBuilderException.newException("CompositeWidgetBuilder needs at least two WidgetBuilders");
        }
        this.mWidgetBuilders = new WidgetBuilder[widgetBuilders.length];
        int length = widgetBuilders.length;
        for (int loop = 0; loop < length; ++loop) {
            WidgetBuilder<W, M> widgetBuilder = widgetBuilders[loop];
            for (int checkDuplicates = 0; checkDuplicates < loop; ++checkDuplicates) {
                if (!this.mWidgetBuilders[checkDuplicates].equals(widgetBuilder)) continue;
                throw WidgetBuilderException.newException("CompositeWidgetBuilder's list of WidgetBuilders contains two of the same " + widgetBuilder.getClass().getName());
            }
            this.mWidgetBuilders[loop] = widgetBuilder;
        }
    }

    @Override
    public W buildWidget(String elementName, Map<String, String> attributes, M metawidget) {
        for (WidgetBuilder<W, M> widgetBuilder : this.mWidgetBuilders) {
            W widget = widgetBuilder.buildWidget(elementName, attributes, metawidget);
            if (widget == null) continue;
            return widget;
        }
        return null;
    }

    public WidgetBuilder<W, M>[] getWidgetBuilders() {
        WidgetBuilder[] widgetBuilders = new WidgetBuilder[this.mWidgetBuilders.length];
        System.arraycopy(this.mWidgetBuilders, 0, widgetBuilders, 0, this.mWidgetBuilders.length);
        return widgetBuilders;
    }
}

