/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.tasks.build;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Rmic;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.jboss.ant.tasks.build.BuildTask;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValidateLicenseHeadersTask
extends BuildTask {
    static final String COPYRIGHT_REGEX = "copyright\\s(\\(c\\))*\\s*[\\d]+(\\s*,\\s*[\\d]+|\\s*-\\s*[\\d]+)*";
    static final String DEFAULT_HEADER = "/*\n * JBoss, Home of Professional Open Source\n * Copyright 2005, JBoss Inc., and individual contributors as indicated\n * by the @authors tag. See the copyright.txt in the distribution for a\n * full listing of individual contributors.\n *\n * This is free software; you can redistribute it and/or modify it\n * under the terms of the GNU Lesser General Public License as\n * published by the Free Software Foundation; either version 2.1 of\n * the License, or (at your option) any later version.\n *\n * This software is distributed in the hope that it will be useful,\n * but WITHOUT ANY WARRANTY; without even the implied warranty of\n * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n * Lesser General Public License for more details.\n *\n * You should have received a copy of the GNU Lesser General Public\n * License along with this software; if not, write to the Free\n * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA\n * 02110-1301 USA, or see the FSF site: http://www.fsf.org.\n */\n";
    static Logger log = Logger.getLogger("ValidateCopyrightHeaders");
    private boolean addDefaultHeader = false;
    private FileFilter dotJavaFilter = new DotJavaFilter();
    private TreeMap licenseHeaders = new TreeMap();
    private ArrayList noheaders = new ArrayList();
    private ArrayList invalidheaders = new ArrayList();
    private int totalCount;
    private int jbossCount;
    private String base;
    private String classname;
    private String verify;
    private String debug;
    private String includes;
    private String external;
    private Path classpath;
    private String licenseInfoPath;
    private URL licenseInfoURL;
    private String noHeadersFile = "NoHeaders.txt";
    private String invalidHeadersFile = "InvalidHeaders.txt";
    private String headersSummaryFile = "HeadersSummary.txt";

    public void execute2() {
        this.setTaskName("RMICHelper");
        if (this.getExternal() != null && this.getExternal().equalsIgnoreCase("true")) {
            String[] classes = this.getIncludes().split(", ");
            for (int i = 0; i < classes.length; ++i) {
                Rmic rmic = new Rmic();
                rmic.setTaskName("rmic");
                rmic.setProject(this.getProject());
                this.getProject().log("Classname: " + this.removeExtension(classes[i]).trim(), 4);
                rmic.setClassname(this.removeExtension(classes[i]).trim());
                this.getProject().log("Verify: " + this.getVerify(), 4);
                rmic.setVerify(this.getBooleanValue(this.getVerify()));
                this.getProject().log("Debug: " + this.getDebug(), 4);
                rmic.setDebug(this.getBooleanValue(this.getDebug()));
                this.getProject().log("Classpath: " + this.getClasspath().toString(), 4);
                rmic.setClasspath(this.getClasspath());
                rmic.setBase(new File(this.getBase()));
                this.getProject().log("Base: " + this.getBase(), 4);
                rmic.execute();
            }
        } else {
            Rmic rmic = new Rmic();
            rmic.setTaskName("rmic");
            rmic.setProject(this.getProject());
            this.getProject().log("Includes: " + this.getIncludes(), 4);
            rmic.setIncludes(this.getIncludes());
            this.getProject().log("Verify: " + this.getVerify(), 4);
            rmic.setVerify(this.getBooleanValue(this.getVerify()));
            this.getProject().log("Debug: " + this.getDebug(), 4);
            rmic.setDebug(this.getBooleanValue(this.getDebug()));
            this.getProject().log("Classpath: " + this.getClasspath().toString(), 4);
            rmic.setClasspath(this.getClasspath());
            this.getProject().log("Base: " + this.getBase(), 4);
            rmic.setBase(new File(this.getBase()));
            rmic.execute();
        }
    }

    private String removeExtension(String classname) {
        int dot = classname.lastIndexOf(".class");
        if (dot == -1) {
            return classname;
        }
        return classname.substring(dot + 1);
    }

    private boolean getBooleanValue(String value) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new BuildException("The string 'value' must resolve to either true or false but it's current value is " + value);
    }

    protected String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public String getDebug() {
        return this.debug;
    }

    public void setDebug(String debug) {
        this.debug = debug;
    }

    public String getVerify() {
        return this.verify;
    }

    public void setVerify(String verify) {
        this.verify = verify;
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getExternal() {
        return this.external;
    }

    public void setExternal(String external) {
        this.external = external;
    }

    public void setClasspath(Path s) {
        this.createClasspath().append(s);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference ref) {
        this.createClasspath().setRefid(ref);
    }

    public String getLicenseInfoPath() {
        return this.licenseInfoPath;
    }

    public void setLicenseInfoPath(String licenseInfoPath) {
        this.licenseInfoPath = licenseInfoPath;
    }

    public URL getLicenseInfoURL() {
        return this.licenseInfoURL;
    }

    public void setLicenseInfoURL(URL licenseInfoURL) {
        this.licenseInfoURL = licenseInfoURL;
    }

    public void execute() {
        try {
            this.internalExceute();
        }
        catch (Exception e) {
            this.getProject().log("Failed to execute header validation");
            e.printStackTrace();
        }
    }

    private void internalExceute() throws Exception {
        File f;
        File jbossSrcRoot;
        this.setTaskName("ValidateLicenseHeaders");
        Project project = this.getProject();
        if (this.base == null) {
            this.base = project.getBaseDir().getPath();
        }
        if (!(jbossSrcRoot = new File(this.base)).exists()) {
            log.info("Src root does not exist, check " + jbossSrcRoot.getAbsolutePath());
            System.exit(1);
        }
        File licenseInfo = project.resolveFile(this.licenseInfoPath);
        InputStream licenseInfoIS = null;
        if (!licenseInfo.exists()) {
            if (this.licenseInfoURL == null) {
                this.licenseInfoURL = new URL("http://repository.jboss.com/licenses/license-info.xml");
            }
            licenseInfoIS = this.licenseInfoURL.openStream();
        } else {
            licenseInfoIS = new FileInputStream(licenseInfo);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = factory.newDocumentBuilder();
        Document doc = db.parse(licenseInfoIS);
        NodeList licenses = doc.getElementsByTagName("license");
        for (int i = 0; i < licenses.getLength(); ++i) {
            Element license = (Element)licenses.item(i);
            String key = license.getAttribute("id");
            ArrayList<LicenseHeader> headers = new ArrayList<LicenseHeader>();
            this.licenseHeaders.put(key, headers);
            NodeList copyrights = license.getElementsByTagName("terms-header");
            for (int j = 0; j < copyrights.getLength(); ++j) {
                String text;
                Element copyright = (Element)copyrights.item(j);
                copyright.normalize();
                String id = copyright.getAttribute("id");
                if (id.length() == 0 || (text = this.getElementContent(copyright)) == null || (text = text.replaceAll("[\\s*]+", " ")).length() == 1) continue;
                text = text.toLowerCase().trim();
                text = text.replaceAll(COPYRIGHT_REGEX, "...");
                LicenseHeader lh = new LicenseHeader(id, text);
                headers.add(lh);
            }
        }
        log.fine(this.licenseHeaders.toString());
        File[] files = jbossSrcRoot.listFiles(this.dotJavaFilter);
        log.info("Root files count: " + files.length);
        this.processSourceFiles(files, 0);
        log.info("Processed " + this.totalCount);
        log.info("Updated jboss headers: " + this.jbossCount);
        log.info("Files with no headers: " + this.noheaders.size());
        FileWriter fw = new FileWriter(this.noHeadersFile);
        Iterator<Object> iter = this.noheaders.iterator();
        while (iter.hasNext()) {
            f = (File)iter.next();
            fw.write(f.getAbsolutePath());
            fw.write(10);
        }
        fw.close();
        log.info("Files with invalid headers: " + this.invalidheaders.size());
        fw = new FileWriter(this.invalidHeadersFile);
        iter = this.invalidheaders.iterator();
        while (iter.hasNext()) {
            f = (File)iter.next();
            fw.write(f.getAbsolutePath());
            fw.write(10);
        }
        fw.close();
        log.info("Creating " + this.headersSummaryFile);
        fw = new FileWriter(this.headersSummaryFile);
        iter = this.licenseHeaders.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String key = (String)entry.getKey();
            fw.write("+++ License type=" + key);
            fw.write(10);
            List list = (List)entry.getValue();
            Iterator jiter = list.iterator();
            while (jiter.hasNext()) {
                LicenseHeader lh = (LicenseHeader)jiter.next();
                fw.write(9);
                fw.write(lh.id);
                fw.write(", count=");
                fw.write("" + lh.count);
                fw.write(10);
            }
        }
        fw.close();
    }

    public String getElementContent(Element element) {
        if (element == null) {
            return null;
        }
        NodeList children = element.getChildNodes();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3 || child.getNodeType() == 4) {
                result.append(child.getNodeValue());
                continue;
            }
            if (child.getNodeType() == 8) continue;
            result.append(child.getFirstChild());
        }
        return result.toString().trim();
    }

    private void processSourceFiles(File[] files, int level) throws IOException {
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (level == 0) {
                log.info("processing " + f);
            }
            if (f.isDirectory()) {
                File[] children = f.listFiles(this.dotJavaFilter);
                this.processSourceFiles(children, level + 1);
                continue;
            }
            this.parseHeader(f);
        }
    }

    private void parseHeader(File javaFile) throws IOException {
        ++this.totalCount;
        RandomAccessFile raf = new RandomAccessFile(javaFile, "rw");
        String line = raf.readLine();
        StringBuffer tmp = new StringBuffer();
        long endOfHeader = 0L;
        boolean packageOrImport = false;
        while (line != null) {
            long nextEOH = raf.getFilePointer();
            if ((line = line.trim()).startsWith("//")) {
                line = raf.readLine();
                continue;
            }
            if (line.startsWith("package") || line.startsWith("import") || line.indexOf("class") >= 0 || line.indexOf("interface") >= 0) {
                packageOrImport = true;
                break;
            }
            endOfHeader = nextEOH;
            if (line.startsWith("/**")) {
                tmp.append(line.substring(3));
            } else if (line.startsWith("/*")) {
                tmp.append(line.substring(2));
            } else if (line.startsWith("*")) {
                tmp.append(line.substring(1));
            } else {
                tmp.append(line);
            }
            tmp.append(' ');
            line = raf.readLine();
        }
        raf.close();
        if (tmp.length() == 0 || !packageOrImport) {
            this.addDefaultHeader(javaFile);
            return;
        }
        String text = tmp.toString();
        text = text.replaceAll("[\\s*]+", " ");
        text = text.toLowerCase().trim();
        text = text.replaceAll(COPYRIGHT_REGEX, "...");
        if (tmp.length() == 0) {
            this.addDefaultHeader(javaFile);
            return;
        }
        boolean matches = false;
        String matchID = null;
        Iterator iter = this.licenseHeaders.entrySet().iterator();
        block1: while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            List list = (List)entry.getValue();
            Iterator jiter = list.iterator();
            while (jiter.hasNext()) {
                LicenseHeader lh = (LicenseHeader)jiter.next();
                if (!text.startsWith(lh.text)) continue;
                matches = true;
                matchID = lh.id;
                ++lh.count;
                lh.usage.add(javaFile);
                if (!log.isLoggable(Level.FINE)) break block1;
                log.fine(javaFile + " matches copyright key=" + key + ", id=" + lh.id);
                break block1;
            }
        }
        text = null;
        tmp.setLength(0);
        if (!matches) {
            this.invalidheaders.add(javaFile);
        } else if (matchID.startsWith("jboss") && !matchID.endsWith("#0")) {
            this.replaceHeader(javaFile, endOfHeader);
            ++this.jbossCount;
        }
    }

    private void replaceHeader(File javaFile, long endOfHeader) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Replacing legacy jboss header in: " + javaFile);
        }
        RandomAccessFile raf = new RandomAccessFile(javaFile, "rw");
        File bakFile = new File(javaFile.getAbsolutePath() + ".bak");
        FileOutputStream fos = new FileOutputStream(bakFile);
        fos.write(DEFAULT_HEADER.getBytes());
        FileChannel fc = raf.getChannel();
        long count = raf.length() - endOfHeader;
        fc.transferTo(endOfHeader, count, fos.getChannel());
        fc.close();
        fos.close();
        raf.close();
        if (!javaFile.delete()) {
            log.severe("Failed to delete java file: " + javaFile);
        }
        if (!bakFile.renameTo(javaFile)) {
            throw new SyncFailedException("Failed to replace: " + javaFile);
        }
    }

    private void addDefaultHeader(File javaFile) throws IOException {
        if (this.addDefaultHeader) {
            FileInputStream fis = new FileInputStream(javaFile);
            FileChannel fc = fis.getChannel();
            int size = (int)fc.size();
            ByteBuffer contents = ByteBuffer.allocate(size);
            fc.read(contents);
            fis.close();
            ByteBuffer hdr = ByteBuffer.wrap(DEFAULT_HEADER.getBytes());
            FileOutputStream fos = new FileOutputStream(javaFile);
            fos.write(hdr.array());
            fos.write(contents.array());
            fos.close();
        }
        this.noheaders.add(javaFile);
    }

    static class DotJavaFilter
    implements FileFilter {
        DotJavaFilter() {
        }

        public boolean accept(File pathname) {
            boolean accept = false;
            String name = pathname.getName();
            accept = pathname.isDirectory() ? !name.equals("gen-src") && !name.equals("gen-parsers") : !name.endsWith("_Stub.java") && name.endsWith(".java");
            return accept;
        }
    }

    static class LicenseHeader {
        String id;
        String text;
        int count;
        ArrayList usage = new ArrayList();

        LicenseHeader(String id, String text) {
            this.id = id;
            this.text = text;
        }
    }
}

