/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.tasks.build;

import org.apache.tools.ant.BuildException;
import org.jboss.ant.tasks.build.BuildTask;
import org.jboss.ant.util.graph.Graph;
import org.jboss.ant.util.graph.Visitor;
import org.jboss.ant.util.graph.VisitorListener;

public class VisitComponentRefGraphTask
extends BuildTask {
    private String componentVisitor;

    public void execute() throws BuildException {
        if (this.getComponentVisitor() == null) {
            throw new BuildException("A componentVisitor must be defined to generate the license information");
        }
        Graph graph = this.getGraph();
        try {
            Class<?> dynamicComponentVisitor = Class.forName(this.getComponentVisitor());
            Object instantiatedVisitor = dynamicComponentVisitor.newInstance();
            if (!(instantiatedVisitor instanceof Visitor)) {
                throw new BuildException("The class " + instantiatedVisitor.getClass() + "cannot be used to visit the graph");
            }
            Visitor visitor = (Visitor)instantiatedVisitor;
            VisitorListener listener = null;
            if (instantiatedVisitor instanceof VisitorListener) {
                listener = (VisitorListener)instantiatedVisitor;
            }
            if (listener != null) {
                listener.beforeVisit(graph, visitor, this.getProject());
            }
            graph.clearMark();
            graph.breadthFirstSearch(graph.getVertex(0), visitor);
            if (listener != null) {
                listener.afterVisit(graph, visitor, this.getProject());
            }
            graph.clearMark();
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Unable to find class: " + this.getComponentVisitor(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BuildException("Unable to instatiate class: " + this.getComponentVisitor(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException("Unable to access class: " + this.getComponentVisitor(), (Throwable)e);
        }
    }

    public String getComponentVisitor() {
        return this.componentVisitor;
    }

    public void setComponentVisitor(String componentVisitor) {
        this.componentVisitor = componentVisitor;
    }
}

