/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.types.component;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.jboss.ant.targets.ArtifactDefinitionTarget;
import org.jboss.ant.types.DynamicType;
import org.jboss.ant.types.Include;
import org.jboss.ant.types.Source;
import org.jboss.ant.types.SourceSink;
import org.jboss.ant.types.build.Artifact;
import org.jboss.ant.types.build.Component;
import org.jboss.ant.types.component.ComponentDefinition;
import org.jboss.ant.types.component.SourceDefinition;
import org.jboss.ant.types.target.TargetDefinition;

public class ArtifactDefinition
extends SourceSink {
    private ComponentDefinition componentDefinition;
    private String artifact;
    private String requiredJDK = "default";
    private boolean buildable;
    private String filename;
    private String toname;

    public Artifact getArtifact() {
        Component component = (Component)((Object)this.getProject().getReference(this.getComponentDefinition().getComponentName()));
        if (component == null) {
            throw new BuildException("Unable to resolve component with id: " + this.getComponentDefinition().getComponentName());
        }
        for (int i = 0; i < component.getArtifacts().size(); ++i) {
            Artifact currentArtifact = (Artifact)((Object)component.getArtifacts().elementAt(i));
            if (!currentArtifact.getId().equalsIgnoreCase(this.artifact)) continue;
            return currentArtifact;
        }
        return null;
    }

    public Component getComponent() {
        return this.getArtifact().getComponent();
    }

    public void setArtifact(String artifact) {
        this.artifact = artifact;
    }

    public String getTargetName() {
        return this.getArtifact().getName();
    }

    public String getClasspath() {
        boolean space = false;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.getSize(); ++i) {
            Include include = this.getInclude(i);
            Iterator j = include.getSources().iterator();
            while (j.hasNext()) {
                Source source = (Source)((Object)j.next());
                if (!(source instanceof SourceDefinition)) continue;
                SourceDefinition sourceDefinition = (SourceDefinition)source;
                if (!space) {
                    space = true;
                } else {
                    buffer.append(" ");
                }
                sourceDefinition.appendClasspath(buffer);
            }
        }
        return buffer.toString();
    }

    public File getOutput() {
        return this.getArtifact().getOutput();
    }

    protected void doValidate() {
        this.getArtifact().validate();
        this.componentDefinition.validate();
        this.determineBuildable();
        super.doValidate();
    }

    protected void appendIdentity(StringBuffer buffer) {
        super.appendIdentity(buffer);
        buffer.append(" artifact=").append(this.artifact);
    }

    protected void toString(StringBuffer buffer) {
        super.toString(buffer);
        buffer.append(" artifact=").append(this.artifact);
    }

    public String getDescription() {
        String description = super.getDescription();
        if (description == null) {
            description = this.getArtifact().getDescription();
        }
        if (description == null) {
            description = this.componentDefinition.getDescription();
        }
        if (description == null) {
            description = this.getArtifact().getId();
        }
        return description;
    }

    public String getRequiredJDK() {
        return this.requiredJDK;
    }

    public void setRequiredJDK(String requiredJDK) {
        this.requiredJDK = requiredJDK;
    }

    public boolean isBuildable() {
        return this.buildable;
    }

    public void setBuildable(boolean buildable) {
        this.buildable = buildable;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getToname() {
        return this.toname;
    }

    public void setToname(String toname) {
        this.toname = toname;
    }

    protected void generateTargets() {
        Vector definitions = this.componentDefinition.getComponent().getTargetDefinitions();
        block0: for (int i = 0; i < definitions.size(); ++i) {
            TargetDefinition definition = (TargetDefinition)((Object)definitions.get(i));
            ArrayList dynamicTypes = definition.getElement(this.getArtifact().getArtifactType().getType());
            ArrayList artifactDefDynamicTypes = definition.getElement("artifactdef");
            if (dynamicTypes == null && artifactDefDynamicTypes != null) {
                dynamicTypes = artifactDefDynamicTypes;
            } else if (dynamicTypes != null && artifactDefDynamicTypes != null) {
                dynamicTypes.addAll(artifactDefDynamicTypes);
            }
            if (dynamicTypes == null) continue;
            for (int j = 0; j < dynamicTypes.size(); ++j) {
                ArtifactDefinitionTarget target = null;
                DynamicType dynamicType = (DynamicType)((Object)dynamicTypes.get(j));
                if (!dynamicType.applies((Object)this)) continue;
                if (target == null) {
                    target = new ArtifactDefinitionTarget(this, definition);
                    this.componentDefinition.addDependency(target);
                }
                this.addDepends(target, dynamicType);
                continue block0;
            }
        }
    }

    protected void setComponentDefinition(ComponentDefinition componentDefinition) {
        this.componentDefinition = componentDefinition;
    }

    protected void determineBuildable() {
        if (this.getRequiredJDK().equalsIgnoreCase("default")) {
            this.setBuildable(true);
        } else if (this.getRequiredJDK().equalsIgnoreCase("1.5")) {
            String version = JavaEnvUtils.getJavaVersion();
            if (version.equalsIgnoreCase(this.getRequiredJDK())) {
                this.setBuildable(true);
            } else {
                this.setBuildable(false);
            }
        } else if (this.getRequiredJDK().equalsIgnoreCase("1.4")) {
            this.setBuildable(true);
        } else {
            throw new BuildException("Invalid value set for attribute requiredJDK\n in source with id: " + this.getId() + " in component definition with id: " + this.getComponent().getId() + "\nAcceptable values are 1.3, 1.4 and 1.5");
        }
    }

    public ComponentDefinition getComponentDefinition() {
        return this.componentDefinition;
    }
}

