/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.types.component;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.jboss.ant.targets.SourceDefinitionTarget;
import org.jboss.ant.types.DynamicType;
import org.jboss.ant.types.Include;
import org.jboss.ant.types.Source;
import org.jboss.ant.types.SourceSink;
import org.jboss.ant.types.build.Artifact;
import org.jboss.ant.types.build.Component;
import org.jboss.ant.types.component.ComponentDefinition;
import org.jboss.ant.types.target.TargetDefinition;
import org.jboss.ant.util.FileUtil;

public class SourceDefinition
extends SourceSink {
    private ComponentDefinition componentDefinition;
    private String test;
    private String requiredJDK = "default";
    private boolean compileable;
    private String excludes15;
    private String excludes;
    private String jvmSource = "1.4";
    private String jvmTarget = "1.4";
    private String sourcedir;
    private String outputdir;

    public Component getComponent() {
        return this.componentDefinition.getComponent();
    }

    public ComponentDefinition getComponentDefinition() {
        return this.componentDefinition;
    }

    public String getSourcePath() {
        if (this.getSourcedir() != null) {
            return this.componentDefinition.getSourcePath(this.getSourcedir());
        }
        return this.componentDefinition.getSourcePath(this.getName());
    }

    public File getSourceDir() {
        return FileUtil.resolve(this.getProject().getBaseDir(), this.getSourcePath());
    }

    public String getTestPath() {
        return this.componentDefinition.getTestPath(this.getName());
    }

    public File getTestDir() {
        return FileUtil.resolve(this.componentDefinition.getOutput(), this.getTestPath());
    }

    public String getTest() {
        return this.test;
    }

    public void setTest(String test) {
        this.test = test;
    }

    public File getOutput() {
        File result = super.getOutput();
        if (result == null) {
            result = this.getOutputdir() != null ? this.componentDefinition.getClassOutput(this.getOutputdir()) : this.componentDefinition.getClassOutput(this.getName());
        }
        return result;
    }

    protected void doValidate() {
        this.componentDefinition.validate();
        if (this.getId() == null) {
            throw new BuildException("Source has no id/name");
        }
        this.determineCompilable();
        this.determineExcludes();
        super.doValidate();
    }

    protected void determineCompilable() {
        if (this.getRequiredJDK().equalsIgnoreCase("default")) {
            this.setCompileable(true);
        } else if (this.getRequiredJDK().equalsIgnoreCase("1.5")) {
            String version = JavaEnvUtils.getJavaVersion();
            if (version.equalsIgnoreCase(this.getRequiredJDK())) {
                this.setCompileable(true);
            } else {
                this.setCompileable(false);
            }
        } else if (this.getRequiredJDK().equalsIgnoreCase("1.4")) {
            String version = JavaEnvUtils.getJavaVersion();
            if (version.equalsIgnoreCase(this.getRequiredJDK())) {
                this.setCompileable(true);
            } else {
                this.setCompileable(false);
            }
        } else {
            throw new BuildException("Invalid value set for attribute requiredJDK\n in source with id: " + this.getId() + " in component definition with id: " + this.getComponent().getId() + "\nAcceptable values are 1.3, 1.4, 1.5, or default.  Default will set the target and source to be the version as the jdk being used");
        }
    }

    protected void determineExcludes() {
        String version;
        if (this.getExcludes() == null) {
            this.setExcludes("");
        }
        if ((version = JavaEnvUtils.getJavaVersion()).equalsIgnoreCase("1.5")) {
            if (this.getExcludes() == null) {
                this.setExcludes(this.getExcludes15());
            } else {
                this.setExcludes(this.getExcludes() + ", " + this.getExcludes15());
            }
        }
    }

    protected void toString(StringBuffer buffer) {
        super.toString(buffer);
        if (this.test != null) {
            buffer.append(" test=").append(this.test);
        }
    }

    public boolean isCompileable() {
        return this.compileable;
    }

    public void setCompileable(boolean compileable) {
        this.compileable = compileable;
    }

    public String getRequiredJDK() {
        return this.requiredJDK;
    }

    public void setRequiredJDK(String requiredJDK) {
        this.requiredJDK = requiredJDK;
    }

    public String getExcludes15() {
        return this.excludes15;
    }

    public void setExcludes15(String excludes15) {
        this.excludes15 = excludes15;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getJvmSource() {
        return this.jvmSource;
    }

    public void setJvmSource(String jvmSource) {
        this.jvmSource = jvmSource;
    }

    public String getJvmTarget() {
        return this.jvmTarget;
    }

    public void setJvmTarget(String jvmTarget) {
        this.jvmTarget = jvmTarget;
    }

    public String getSourcedir() {
        return this.sourcedir;
    }

    public void setSourcedir(String sourcedir) {
        this.sourcedir = sourcedir;
    }

    public String getOutputdir() {
        return this.outputdir;
    }

    public void setOutputdir(String outputdir) {
        this.outputdir = outputdir;
    }

    public String getDescription() {
        String description = super.getDescription();
        if (description == null) {
            description = this.componentDefinition.getDescription();
        }
        if (description == null) {
            description = this.getId();
        }
        return description;
    }

    protected void generateTargets() {
        Vector definitions = this.getComponent().getTargetDefinitions();
        block0: for (int i = 0; i < definitions.size(); ++i) {
            TargetDefinition definition = (TargetDefinition)((Object)definitions.get(i));
            ArrayList dynamicTypes = definition.getElement("source");
            if (dynamicTypes == null) continue;
            for (int j = 0; j < dynamicTypes.size(); ++j) {
                SourceDefinitionTarget target = null;
                DynamicType dynamicType = (DynamicType)((Object)dynamicTypes.get(j));
                if (!dynamicType.applies((Object)this)) continue;
                if (target == null) {
                    target = new SourceDefinitionTarget(this, definition);
                    this.componentDefinition.addDependency(target);
                }
                this.addDepends(target, dynamicType);
                continue block0;
            }
        }
    }

    protected void setComponentDefinition(ComponentDefinition componentDefinition) {
        this.componentDefinition = componentDefinition;
    }

    protected void appendClasspath(StringBuffer buffer) {
        boolean space = false;
        for (int i = 0; i < this.getSize(); ++i) {
            Include include = this.getInclude(i);
            Iterator j = include.getSources().iterator();
            while (j.hasNext()) {
                Artifact artifact;
                Source source = (Source)((Object)j.next());
                if (!(source instanceof Artifact) || !"jar".equals((artifact = (Artifact)source).getArtifactType().getId())) continue;
                if (!space) {
                    space = true;
                } else {
                    buffer.append(" ");
                }
                buffer.append(artifact.getId());
            }
        }
    }
}

