/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.util.graph;

import java.util.Vector;
import org.jboss.ant.util.graph.Edge;

public class Vertex {
    private Vector incomingEdges = new Vector();
    private Vector outgoingEdges = new Vector();
    private String name;
    private boolean mark;
    private int markState;

    public Vertex() {
        this(null);
    }

    public Vertex(String n) {
        this.name = new String(n);
        this.mark = false;
    }

    public String getName() {
        return this.name;
    }

    public boolean addEdge(Edge e) {
        if (e.getFrom() == this) {
            this.outgoingEdges.addElement(e);
        } else if (e.getTo() == this) {
            this.incomingEdges.addElement(e);
        } else {
            return false;
        }
        return true;
    }

    public boolean hasEdge(Edge e) {
        if (e.getFrom() == this) {
            return this.incomingEdges.contains(e);
        }
        if (e.getTo() == this) {
            return this.outgoingEdges.contains(e);
        }
        return false;
    }

    public boolean remove(Edge e) {
        if (e.getFrom() == this) {
            this.incomingEdges.removeElement(e);
        } else if (e.getTo() == this) {
            this.outgoingEdges.removeElement(e);
        } else {
            return false;
        }
        return true;
    }

    public int getIncomingEdgeCount() {
        return this.incomingEdges.size();
    }

    public Edge getIncomingEdge(int i) {
        Edge e = (Edge)this.incomingEdges.get(i);
        return e;
    }

    public int getOutgoingEdgeCount() {
        return this.outgoingEdges.size();
    }

    public Edge getOutgoingEdge(int i) {
        Edge e = (Edge)this.outgoingEdges.get(i);
        return e;
    }

    public Edge findEdge(Vertex dest) {
        for (int i = 0; i < this.incomingEdges.size(); ++i) {
            Edge e = (Edge)this.incomingEdges.elementAt(i);
            if (e.getTo() != dest) continue;
            return e;
        }
        return null;
    }

    public Edge findEdge(Edge e) {
        if (this.incomingEdges.contains(e)) {
            return e;
        }
        return null;
    }

    public int cost(Vertex dest) {
        if (dest == this) {
            return 0;
        }
        Edge e = this.findEdge(dest);
        if (e != null) {
            return e.getCost();
        }
        return Integer.MAX_VALUE;
    }

    public boolean hasEdge(Vertex dest) {
        return this.findEdge(dest) != null;
    }

    public boolean visited() {
        return this.mark;
    }

    public void mark() {
        this.mark = true;
    }

    public void setMarkState(int state) {
        this.markState = state;
    }

    public int getMarkState() {
        return this.markState;
    }

    public void visit() {
        this.mark();
    }

    public void clearMark() {
        this.mark = false;
    }

    public String toString() {
        Edge e;
        int i;
        StringBuffer tmp = new StringBuffer("Vertex(");
        tmp.append(this.name);
        tmp.append("), in:[");
        for (i = 0; i < this.incomingEdges.size(); ++i) {
            e = (Edge)this.incomingEdges.elementAt(i);
            if (i > 0) {
                tmp.append(',');
            }
            tmp.append('{');
            tmp.append(e.getFrom().name);
            tmp.append(',');
            tmp.append(e.getCost());
            tmp.append('}');
        }
        tmp.append("], out:[");
        for (i = 0; i < this.outgoingEdges.size(); ++i) {
            e = (Edge)this.outgoingEdges.elementAt(i);
            if (i > 0) {
                tmp.append(',');
            }
            tmp.append('{');
            tmp.append(e.getTo().name);
            tmp.append(',');
            tmp.append(e.getCost());
            tmp.append('}');
        }
        tmp.append(']');
        return tmp.toString();
    }
}

