/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.io.PrintWriter;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.NDC;
import org.jboss.logmanager.formatters.FormatStep;
import org.jboss.logmanager.formatters.StringBuilderWriter;

public final class Formatters {
    private static final Formatter NULL_FORMATTER = new Formatter(){

        @Override
        public String format(LogRecord record) {
            return "";
        }
    };
    private static final PrivilegedAction<ClassLoader> GET_TCCL_ACTION = new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };
    private static final String separatorString = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });

    private Formatters() {
    }

    public static Formatter nullFormatter() {
        return NULL_FORMATTER;
    }

    public static FormatStep textFormatStep(final String string) {
        return new FormatStep(){

            @Override
            public void render(StringBuilder builder, ExtLogRecord record) {
                builder.append(string);
            }

            @Override
            public int estimateLength() {
                return string.length();
            }
        };
    }

    private static String applySegments(int count, String subject) {
        if (count == 0) {
            return subject;
        }
        int idx = subject.length() + 1;
        for (int i = 0; i < count; ++i) {
            if ((idx = subject.lastIndexOf(46, idx - 1)) != -1) continue;
            return subject;
        }
        return subject.substring(idx + 1);
    }

    public static FormatStep loggerNameFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth, int count) {
        return new SegmentedFormatStep(leftJustify, minimumWidth, maximumWidth, count){

            @Override
            public String getSegmentedSubject(ExtLogRecord record) {
                return record.getLoggerName();
            }
        };
    }

    public static FormatStep classNameFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth, int count) {
        return new SegmentedFormatStep(leftJustify, minimumWidth, maximumWidth, count){

            @Override
            public String getSegmentedSubject(ExtLogRecord record) {
                return record.getSourceClassName();
            }
        };
    }

    public static FormatStep dateFormatStep(final TimeZone timeZone, String formatString, boolean leftJustify, int minimumWidth, int maximumWidth) {
        final SimpleDateFormat dateFormatMaster = new SimpleDateFormat(formatString == null ? "yyyy-MM-dd HH:mm:ss,SSS" : formatString);
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                String formatted;
                SimpleDateFormat dateFormat = dateFormatMaster;
                dateFormat.setTimeZone(timeZone);
                Date date = new Date(record.getMillis());
                SimpleDateFormat simpleDateFormat = dateFormat;
                synchronized (simpleDateFormat) {
                    formatted = dateFormat.format(date);
                }
                builder.append(formatted);
            }
        };
    }

    public static FormatStep dateFormatStep(String formatString, boolean leftJustify, int minimumWidth, int maximumWidth) {
        return Formatters.dateFormatStep(TimeZone.getDefault(), formatString, leftJustify, minimumWidth, maximumWidth);
    }

    public static FormatStep fileNameFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                builder.append(record.getSourceFileName());
            }
        };
    }

    public static FormatStep locationInformationFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                String fileName = record.getSourceFileName();
                int lineNumber = record.getSourceLineNumber();
                String className = record.getSourceClassName();
                String methodName = record.getSourceMethodName();
                builder.append(className).append('.').append(methodName);
                builder.append('(').append(fileName);
                if (lineNumber != -1) {
                    builder.append(':').append(lineNumber);
                }
                builder.append(')');
            }
        };
    }

    public static FormatStep lineNumberFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                builder.append(record.getSourceLineNumber());
            }
        };
    }

    public static FormatStep messageFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                builder.append(record.getFormattedMessage());
                Throwable t = record.getThrown();
                if (t != null) {
                    builder.append(": ");
                    t.printStackTrace(new PrintWriter(new StringBuilderWriter(builder)));
                }
            }
        };
    }

    public static FormatStep simpleMessageFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                builder.append(record.getFormattedMessage());
            }
        };
    }

    public static FormatStep exceptionFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth, final boolean extended) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                Throwable t = record.getThrown();
                if (t != null) {
                    Throwable cause;
                    HashMap<String, String> cache;
                    builder.append(": ").append(t).append('\n');
                    StackTraceElement[] stackTrace = t.getStackTrace();
                    HashMap<String, String> hashMap = cache = extended ? new HashMap<String, String>() : null;
                    if (extended) {
                        for (StackTraceElement element : stackTrace) {
                            this.renderExtended(builder, element, cache);
                        }
                    } else {
                        for (StackTraceElement element : stackTrace) {
                            this.renderTrivial(builder, element);
                        }
                    }
                    if ((cause = t.getCause()) != null) {
                        this.renderCause(builder, t, cause, cache, extended);
                    }
                }
            }

            private void renderTrivial(StringBuilder builder, StackTraceElement element) {
                builder.append("\tat ").append(element).append('\n');
            }

            private void renderExtended(StringBuilder builder, StackTraceElement element, Map<String, String> cache) {
                builder.append("\tat ").append(element);
                String className = element.getClassName();
                String cached = cache.get(className);
                if (cached != null) {
                    builder.append(cached).append('\n');
                    return;
                }
                int dotIdx = className.lastIndexOf(46);
                if (dotIdx == -1) {
                    return;
                }
                String packageName = className.substring(0, dotIdx);
                final Class<?> exceptionClass = this.guessClass(className);
                Package exceptionPackage = null;
                if (exceptionClass != null) {
                    exceptionPackage = exceptionClass.getPackage();
                }
                if (exceptionPackage == null) {
                    try {
                        exceptionPackage = Package.getPackage(packageName);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                String packageVersion = null;
                if (exceptionPackage != null) {
                    try {
                        packageVersion = exceptionPackage.getImplementationVersion();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (packageVersion == null) {
                        try {
                            packageVersion = exceptionPackage.getSpecificationVersion();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                }
                URL resource = null;
                SecurityManager sm = System.getSecurityManager();
                final String classResourceName = className.replace('.', '/') + ".class";
                if (exceptionClass != null) {
                    try {
                        if (sm == null) {
                            CodeSource codeSource;
                            ProtectionDomain protectionDomain = exceptionClass.getProtectionDomain();
                            if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null) {
                                resource = codeSource.getLocation();
                            }
                        } else {
                            resource = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                                @Override
                                public URL run() {
                                    CodeSource codeSource;
                                    ProtectionDomain protectionDomain = exceptionClass.getProtectionDomain();
                                    if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null) {
                                        return codeSource.getLocation();
                                    }
                                    return null;
                                }
                            });
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (resource == null) {
                        try {
                            final ClassLoader exceptionClassLoader = exceptionClass.getClassLoader();
                            resource = sm == null ? (exceptionClassLoader == null ? ClassLoader.getSystemResource(classResourceName) : exceptionClassLoader.getResource(classResourceName)) : AccessController.doPrivileged(new PrivilegedAction<URL>(){

                                @Override
                                public URL run() {
                                    return exceptionClassLoader == null ? ClassLoader.getSystemResource(classResourceName) : exceptionClassLoader.getResource(classResourceName);
                                }
                            });
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                }
                String jarName = null;
                if (resource != null) {
                    int endIdx;
                    int lsIdx;
                    String firstPart;
                    String path = resource.getPath();
                    String protocol = resource.getProtocol();
                    if ("jar".equals(protocol)) {
                        int sepIdx = path.lastIndexOf("!/");
                        if (sepIdx != -1) {
                            firstPart = path.substring(0, sepIdx);
                            lsIdx = Math.max(firstPart.lastIndexOf(47), firstPart.lastIndexOf(92));
                            jarName = lsIdx != -1 ? firstPart.substring(lsIdx + 1) : firstPart;
                        }
                    } else if ("module".equals(protocol)) {
                        jarName = resource.getPath();
                    }
                    if (jarName == null && (endIdx = path.lastIndexOf(classResourceName)) != -1) {
                        while (path.charAt(--endIdx) == '/' || path.charAt(endIdx) == '\\' || path.charAt(endIdx) == '?') {
                        }
                        firstPart = path.substring(0, endIdx);
                        lsIdx = Math.max(firstPart.lastIndexOf(47), firstPart.lastIndexOf(92));
                        jarName = lsIdx != -1 ? firstPart.substring(lsIdx + 1) : firstPart;
                    }
                    if (jarName == null) {
                        endIdx = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
                        jarName = endIdx != -1 ? path.substring(endIdx + 1) : path;
                    }
                    if (jarName == null && exceptionClass != null && exceptionClass.getClassLoader() == null) {
                        jarName = "(bootstrap)";
                    }
                }
                boolean started = false;
                StringBuilder tagBuilder = new StringBuilder();
                if (jarName != null) {
                    started = true;
                    tagBuilder.append(" [").append(jarName).append(':');
                }
                if (packageVersion != null) {
                    if (!started) {
                        tagBuilder.append(" [:");
                        started = true;
                    }
                    tagBuilder.append(packageVersion);
                }
                if (started) {
                    tagBuilder.append(']');
                    String tag = tagBuilder.toString();
                    cache.put(className, tag);
                    builder.append(tag);
                } else {
                    cache.put(className, "");
                }
                builder.append('\n');
            }

            private Class<?> guessClass(String name) {
                SecurityManager sm = System.getSecurityManager();
                try {
                    try {
                        ClassLoader tccl;
                        ClassLoader classLoader = tccl = sm != null ? (ClassLoader)AccessController.doPrivileged(GET_TCCL_ACTION) : (ClassLoader)GET_TCCL_ACTION.run();
                        if (tccl != null) {
                            return Class.forName(name, false, tccl);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                    try {
                        return Class.forName(name);
                    }
                    catch (ClassNotFoundException e) {
                        return Class.forName(name, false, null);
                    }
                }
                catch (Throwable t) {
                    return null;
                }
            }

            private void renderCause(StringBuilder builder, Throwable t, Throwable cause, Map<String, String> cache, boolean extended2) {
                Throwable ourCause;
                int i;
                StackTraceElement[] causeStack = cause.getStackTrace();
                StackTraceElement[] currentStack = t.getStackTrace();
                int m = causeStack.length - 1;
                for (int n = currentStack.length - 1; m >= 0 && n >= 0 && causeStack[m].equals(currentStack[n]); --m, --n) {
                }
                int framesInCommon = causeStack.length - 1 - m;
                builder.append("Caused by: ").append(cause).append('\n');
                if (extended2) {
                    for (i = 0; i <= m; ++i) {
                        this.renderExtended(builder, causeStack[i], cache);
                    }
                } else {
                    for (i = 0; i <= m; ++i) {
                        this.renderTrivial(builder, causeStack[i]);
                    }
                }
                if (framesInCommon != 0) {
                    builder.append("\t... ").append(framesInCommon).append(" more").append('\n');
                }
                if ((ourCause = cause.getCause()) != null) {
                    this.renderCause(builder, cause, ourCause, cache, extended2);
                }
            }
        };
    }

    public static FormatStep resourceKeyFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                String key = record.getResourceKey();
                if (key != null) {
                    builder.append(key);
                }
            }
        };
    }

    public static FormatStep methodNameFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                builder.append(record.getSourceMethodName());
            }
        };
    }

    public static FormatStep lineSeparatorFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                builder.append(separatorString);
            }
        };
    }

    public static FormatStep levelFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                Level level = record.getLevel();
                builder.append(level.getResourceBundleName() != null ? level.getLocalizedName() : level.getName());
            }
        };
    }

    public static FormatStep relativeTimeFormatStep(final long baseTime, boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                builder.append(record.getMillis() - baseTime);
            }
        };
    }

    public static FormatStep threadNameFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                builder.append(record.getThreadName());
            }
        };
    }

    public static FormatStep ndcFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
        return Formatters.ndcFormatStep(leftJustify, minimumWidth, maximumWidth, 0);
    }

    public static FormatStep ndcFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth, int count) {
        return new SegmentedFormatStep(leftJustify, minimumWidth, maximumWidth, count){

            @Override
            public String getSegmentedSubject(ExtLogRecord record) {
                return NDC.get();
            }
        };
    }

    public static FormatStep mdcFormatStep(final String key, boolean leftJustify, int minimumWidth, int maximumWidth) {
        return new JustifyingFormatStep(leftJustify, minimumWidth, maximumWidth){

            @Override
            public void renderRaw(StringBuilder builder, ExtLogRecord record) {
                String value = record.getMdc(key);
                if (value != null) {
                    builder.append(value);
                }
            }
        };
    }

    private static abstract class SegmentedFormatStep
    extends JustifyingFormatStep {
        private final int count;

        protected SegmentedFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth, int count) {
            super(leftJustify, minimumWidth, maximumWidth);
            this.count = count;
        }

        @Override
        public void renderRaw(StringBuilder builder, ExtLogRecord record) {
            builder.append(Formatters.applySegments(this.count, this.getSegmentedSubject(record)));
        }

        public abstract String getSegmentedSubject(ExtLogRecord var1);
    }

    private static abstract class JustifyingFormatStep
    implements FormatStep {
        private final boolean leftJustify;
        private final int minimumWidth;
        private final int maximumWidth;

        protected JustifyingFormatStep(boolean leftJustify, int minimumWidth, int maximumWidth) {
            if (maximumWidth != 0 && minimumWidth > maximumWidth) {
                throw new IllegalArgumentException("Specified minimum width may not be greater than the specified maximum width");
            }
            if (maximumWidth < 0 || minimumWidth < 0) {
                throw new IllegalArgumentException("Minimum and maximum widths must not be less than zero");
            }
            this.leftJustify = leftJustify;
            this.minimumWidth = minimumWidth;
            this.maximumWidth = maximumWidth == 0 ? Integer.MAX_VALUE : maximumWidth;
        }

        @Override
        public void render(StringBuilder builder, ExtLogRecord record) {
            int minimumWidth = this.minimumWidth;
            int maximumWidth = this.maximumWidth;
            boolean leftJustify = this.leftJustify;
            if (leftJustify) {
                int oldLen = builder.length();
                this.renderRaw(builder, record);
                int newLen = builder.length();
                int writtenLen = newLen - oldLen;
                int overflow = writtenLen - maximumWidth;
                if (overflow > 0) {
                    builder.setLength(newLen - overflow);
                } else {
                    int spaces = minimumWidth - writtenLen;
                    for (int i = 0; i < spaces; ++i) {
                        builder.append(' ');
                    }
                }
            } else {
                StringBuilder subBuilder = new StringBuilder();
                this.renderRaw(subBuilder, record);
                int len = subBuilder.length();
                if (len > maximumWidth) {
                    subBuilder.setLength(maximumWidth);
                } else if (len < minimumWidth) {
                    int spaces = minimumWidth - len;
                    for (int i = 0; i < spaces; ++i) {
                        builder.append(' ');
                    }
                }
                builder.append((CharSequence)subBuilder);
            }
        }

        @Override
        public int estimateLength() {
            int maximumWidth = this.maximumWidth;
            int minimumWidth = this.minimumWidth;
            if (maximumWidth != 0) {
                return Math.min(maximumWidth, minimumWidth * 3);
            }
            return Math.max(32, minimumWidth);
        }

        public abstract void renderRaw(StringBuilder var1, ExtLogRecord var2);
    }
}

