/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.hibernate.eclipse.console.model.impl.ExporterDefinition;

public class ExtensionManager {
    public static final String EXPORTERS_EXTENSION_ID = "org.hibernate.eclipse.console.exporters";

    private static IExtension[] findExtensions(String extensionId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionId);
        return extensionPoint.getExtensions();
    }

    public static ExporterDefinition[] findExporterDefinitions() {
        ArrayList<ExporterDefinition> exporters = new ArrayList<ExporterDefinition>();
        IExtension[] extensions = ExtensionManager.findExtensions(EXPORTERS_EXTENSION_ID);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                ExporterDefinition exporter = new ExporterDefinition(elements[j]);
                exporters.add(exporter);
                ++j;
            }
            ++i;
        }
        return exporters.toArray(new ExporterDefinition[exporters.size()]);
    }

    public static Map<String, ExporterDefinition> findExporterDefinitionsAsMap() {
        HashMap<String, ExporterDefinition> result = new HashMap<String, ExporterDefinition>();
        ExporterDefinition[] findExporterDefinitions = ExtensionManager.findExporterDefinitions();
        int i = 0;
        while (i < findExporterDefinitions.length) {
            ExporterDefinition exporterDefinition = findExporterDefinitions[i];
            result.put(exporterDefinition.getId(), exporterDefinition);
            ++i;
        }
        return result;
    }
}

