/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.hibernate.HibernateException;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.KnownConfigurationsAdapter;
import org.hibernate.console.KnownConfigurationsListener;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.EclipseConsoleConfiguration;
import org.hibernate.eclipse.console.EclipseConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.EclipseLaunchConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.utils.LaunchHelper;
import org.hibernate.eclipse.console.workbench.ConfigurationAdapterFactory;
import org.hibernate.eclipse.criteriaeditor.CriteriaEditorInput;
import org.hibernate.eclipse.criteriaeditor.CriteriaEditorStorage;
import org.hibernate.eclipse.hqleditor.HQLEditorInput;
import org.hibernate.eclipse.hqleditor.HQLEditorStorage;
import org.hibernate.eclipse.launch.core.refactoring.ConsoleConfigurationRenameProcessor;
import org.hibernate.eclipse.logging.PluginLogger;
import org.hibernate.eclipse.logging.xpl.EclipseLogger;
import org.osgi.framework.BundleContext;

public class HibernateConsolePlugin
extends AbstractUIPlugin
implements PluginLogger {
    public static final String ID = "org.hibernate.eclipse.console";
    public static final String LAST_USED_CONFIGURATION_PREFERENCE = "lastusedconfig";
    public static final int PERFORM_SYNC_EXEC = 1;
    private static HibernateConsolePlugin plugin;
    private ResourceBundle resourceBundle;
    private EclipseLogger logger;
    private JavaTextTools javaTextTools;
    private ILaunchConfigurationListener icl;
    private KnownConfigurationsListener kcl;

    public HibernateConsolePlugin() {
        HibernateConsolePlugin.setPlugin(this);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.logger = new EclipseLogger(context.getBundle());
        IAdapterManager adapterManager = Platform.getAdapterManager();
        ConfigurationAdapterFactory fact = new ConfigurationAdapterFactory();
        fact.registerAdapters(adapterManager);
        this.loadExistingConfigurations();
        this.listenForConfigurations();
    }

    private void listenForConfigurations() {
        final ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        this.kcl = new KnownConfigurationsAdapter(){

            public void configurationRemoved(ConsoleConfiguration root, boolean forUpdate) {
                if (!forUpdate) {
                    try {
                        HibernateConsolePlugin.this.removeConfiguration(root.getName());
                    }
                    catch (CoreException e) {
                        HibernateConsolePlugin.this.logErrorMessage(String.valueOf(HibernateConsoleMessages.HibernateConsolePlugin_could_not_delete_launch_config_for) + root.getName(), e);
                    }
                }
            }
        };
        KnownConfigurations.getInstance().addConsoleConfigurationListener(this.kcl);
        this.icl = new ILaunchConfigurationListener(){

            boolean isConsoleConfiguration(ILaunchConfiguration configuration) {
                try {
                    return configuration.getType().getIdentifier().equals("org.hibernate.eclipse.launch.ConsoleConfigurationLaunchConfigurationType");
                }
                catch (CoreException coreException) {
                    return false;
                }
            }

            public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
                ConsoleConfiguration cfg = KnownConfigurations.getInstance().find(configuration.getName());
                if (cfg != null) {
                    KnownConfigurations.getInstance().removeConfiguration(cfg, true);
                }
            }

            public void launchConfigurationChanged(ILaunchConfiguration configuration) {
                if (configuration.isWorkingCopy() || this.isTemporary(configuration)) {
                    return;
                }
                if (this.isConsoleConfiguration(configuration)) {
                    KnownConfigurations instance = KnownConfigurations.getInstance();
                    ConsoleConfiguration oldcfg = instance.find(configuration.getName());
                    if (oldcfg != null) {
                        oldcfg.reset();
                    } else {
                        ConsoleConfigurationPreferences adapter = this.buildConfigurationPreferences(configuration);
                        instance.addConfiguration(new ConsoleConfiguration(adapter), true);
                    }
                }
            }

            private ConsoleConfigurationPreferences buildConfigurationPreferences(ILaunchConfiguration configuration) {
                return new EclipseLaunchConsoleConfigurationPreferences(configuration);
            }

            public void launchConfigurationAdded(ILaunchConfiguration configuration) {
                if (this.isConsoleConfiguration(configuration)) {
                    KnownConfigurations instance;
                    ConsoleConfiguration oldcfg;
                    ILaunchConfiguration movedFrom = launchManager.getMovedFrom(configuration);
                    if (movedFrom != null && this.isConsoleConfiguration(movedFrom) && (oldcfg = (instance = KnownConfigurations.getInstance()).find(movedFrom.getName())) != null) {
                        this.refactor(movedFrom, configuration);
                        oldcfg.reset();
                        instance.removeConfiguration(oldcfg, false);
                    }
                    instance = KnownConfigurations.getInstance();
                    ConsoleConfigurationPreferences adapter = this.buildConfigurationPreferences(configuration);
                    boolean temporary = this.isTemporary(configuration);
                    if (!temporary) {
                        instance.addConfiguration(new ConsoleConfiguration(adapter), true);
                    }
                }
            }

            private void refactor(ILaunchConfiguration oldConfiguration, ILaunchConfiguration newConfiguration) {
                if (!oldConfiguration.getName().equals(newConfiguration.getName())) {
                    ConsoleConfigurationRenameProcessor proc = new ConsoleConfigurationRenameProcessor(oldConfiguration, newConfiguration.getName());
                    PerformRefactoringOperation refOperation = new PerformRefactoringOperation((Refactoring)new ProcessorBasedRefactoring((RefactoringProcessor)proc), 6);
                    try {
                        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)refOperation, null);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new OperationCanceledException();
                    }
                    catch (CoreException ce) {
                        HibernateConsolePlugin.openError(new Shell(), HibernateConsoleMessages.EditConsoleConfiguration_rename_refactoring_error_totle, ce.getLocalizedMessage(), ce, 1);
                    }
                }
            }

            private boolean isTemporary(ILaunchConfiguration configuration) {
                boolean temporary = true;
                try {
                    temporary = configuration.getAttribute("_TEMPORARY_CONFIG_", false);
                }
                catch (CoreException e) {
                    HibernateConsolePlugin.getDefault().showError(HibernateConsolePlugin.getShell(), HibernateConsoleMessages.HibernateConsolePlugin_problem_to_get_flag, e);
                }
                return temporary;
            }
        };
        launchManager.addLaunchConfigurationListener(this.icl);
    }

    private void stopListeningForConfigurations() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.removeLaunchConfigurationListener(this.icl);
        KnownConfigurations.getInstance().removeConfigurationListener(this.kcl);
    }

    private void loadExistingConfigurations() throws CoreException {
        ILaunchConfiguration[] launchConfigurations = LaunchHelper.findHibernateLaunchConfigs();
        int i = 0;
        while (i < launchConfigurations.length) {
            KnownConfigurations.getInstance().addConfiguration(new ConsoleConfiguration((ConsoleConfigurationPreferences)new EclipseLaunchConsoleConfigurationPreferences(launchConfigurations[i])), false);
            ++i;
        }
    }

    private void removeConfiguration(String name) throws CoreException {
        ILaunchConfiguration findLaunchConfig = this.findLaunchConfig(name);
        if (findLaunchConfig != null) {
            findLaunchConfig.delete();
        }
    }

    public ILaunchConfiguration findLaunchConfig(String name) throws CoreException {
        return LaunchHelper.findHibernateLaunchConfig(name);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.stopListeningForConfigurations();
        HibernateConsolePlugin.setPlugin(null);
        this.resourceBundle = null;
    }

    public static HibernateConsolePlugin getDefault() {
        return plugin;
    }

    private static void setPlugin(HibernateConsolePlugin plugin) {
        HibernateConsolePlugin.plugin = plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = HibernateConsolePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.hibernate.eclipse.console.HibernateConsolePluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public void log(IStatus status) {
        this.logger.log(status);
    }

    public void log(String message) {
        this.log((IStatus)new Status(1, ID, 0, message, null));
    }

    public void logErrorMessage(String message, Throwable t) {
        this.logMessage(4, message, t);
    }

    public void logMessage(int lvl, String message, Throwable t) {
        if (t == null) {
            this.log(message);
        } else {
            this.log((IStatus)new MultiStatus(ID, lvl, new IStatus[]{HibernateConsolePlugin.throwableToStatus(t)}, message, null));
        }
    }

    public static IStatus throwableToStatus(Throwable t, int code) {
        ArrayList<Status> causes = new ArrayList<Status>();
        Throwable temp = t;
        while (temp != null && temp.getCause() != temp) {
            causes.add(new Status(4, ID, code, temp.getMessage() == null ? String.valueOf(temp.toString()) + HibernateConsoleMessages.HibernateConsolePlugin_no_message_1 : temp.toString(), temp));
            temp = temp.getCause();
        }
        String msg = HibernateConsoleMessages.HibernateConsolePlugin_no_message_2;
        if (t != null && t.getMessage() != null) {
            msg = t.toString();
        }
        if (causes.isEmpty()) {
            return new Status(4, ID, code, msg, t);
        }
        return new MultiStatus(ID, code, causes.toArray(new IStatus[causes.size()]), msg, t);
    }

    public static IStatus throwableToStatus(Throwable t) {
        return HibernateConsolePlugin.throwableToStatus(t, 150);
    }

    public void logErrorMessage(String message, Throwable[] t) {
        IStatus[] children = new IStatus[t.length];
        int i = 0;
        while (i < t.length) {
            Throwable throwable = t[i];
            children[i] = HibernateConsolePlugin.throwableToStatus(throwable);
            ++i;
        }
        MultiStatus s = new MultiStatus(ID, 150, children, message, null);
        this.log((IStatus)s);
    }

    public void log(Throwable e) {
        this.log((IStatus)new Status(4, ID, 150, "Hibernate Console Internal Error", e));
    }

    void readStateFrom(File f) {
        try {
            EclipseConsoleConfigurationPreferences[] preferences = EclipseConsoleConfigurationPreferences.readStateFrom(f);
            int i = 0;
            while (i < preferences.length) {
                EclipseConsoleConfigurationPreferences prefs = preferences[i];
                KnownConfigurations.getInstance().addConfiguration((ConsoleConfiguration)new EclipseConsoleConfiguration((ConsoleConfigurationPreferences)prefs), false);
                ++i;
            }
        }
        catch (HibernateConsoleRuntimeException hcr) {
            this.logErrorMessage(HibernateConsoleMessages.HibernateConsolePlugin_error_while_reading_console_config, hcr);
        }
    }

    void writeStateTo(File f) {
        KnownConfigurations.getInstance().writeStateTo(f);
    }

    public void showError(Shell shell, String message, Throwable he) {
        this.logErrorMessage(message, he);
        IStatus warning = HibernateConsolePlugin.throwableToStatus(he);
        ErrorDialog.openError((Shell)shell, (String)HibernateConsoleMessages.HibernateConsolePlugin_hibernate_console, (String)message, (IStatus)warning);
    }

    public void showError(Shell shell, String message, IStatus s) {
        this.log(s);
        ErrorDialog.openError((Shell)shell, (String)HibernateConsoleMessages.HibernateConsolePlugin_hibernate_console, (String)message, (IStatus)s);
    }

    public IEditorPart openCriteriaEditor(String consoleName, String criteria) {
        try {
            IWorkbenchPage page = HibernateConsolePlugin.getActiveWorkbenchWindow().getActivePage();
            CriteriaEditorStorage storage = new CriteriaEditorStorage(consoleName, criteria == null ? "" : criteria);
            CriteriaEditorInput editorInput = new CriteriaEditorInput(storage);
            return page.openEditor((IEditorInput)editorInput, "org.hibernate.eclipse.criteriaeditor.CriteriaEditor", true);
        }
        catch (PartInitException ex) {
            this.logErrorMessage(String.valueOf(HibernateConsoleMessages.HibernateConsolePlugin_could_not_open_criteria_editor_for_console) + consoleName, ex);
            return null;
        }
    }

    public IEditorPart openScratchHQLEditor(String consoleName, String hql) {
        try {
            IWorkbenchPage page = HibernateConsolePlugin.getActiveWorkbenchWindow().getActivePage();
            HQLEditorStorage storage = new HQLEditorStorage(consoleName, hql == null ? "" : hql);
            HQLEditorInput editorInput = new HQLEditorInput(storage);
            return page.openEditor((IEditorInput)editorInput, "org.hibernate.eclipse.hqleditor.HQLEditor", true);
        }
        catch (PartInitException ex) {
            this.logErrorMessage(String.valueOf(HibernateConsoleMessages.HibernateConsolePlugin_could_not_open_hql_editor_for_console) + consoleName, ex);
            return null;
        }
    }

    public static IStatus openError(Shell providedShell, String title, String message, Throwable exception, int flags) {
        if (exception instanceof InvocationTargetException) {
            Throwable target = ((InvocationTargetException)exception).getTargetException();
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            return HibernateConsolePlugin.openError(providedShell, title, message, target, flags);
        }
        IStatus status = null;
        if (exception instanceof CoreException) {
            status = ((CoreException)exception).getStatus();
        } else if (exception != null) {
            status = new MultiStatus(ID, 4, new IStatus[]{HibernateConsolePlugin.throwableToStatus(exception.getCause())}, exception.toString(), exception);
        }
        if (status.isOK()) {
            return status;
        }
        final String displayTitle = title;
        final String displayMessage = message;
        final IStatus displayStatus = status;
        IOpenableInShell openable = new IOpenableInShell(){

            @Override
            public void open(Shell shell) {
                if (displayStatus.getSeverity() == 1 && !displayStatus.isMultiStatus()) {
                    MessageDialog.openInformation((Shell)shell, (String)"Information", (String)displayStatus.getMessage());
                } else {
                    ErrorDialog.openError((Shell)shell, (String)displayTitle, (String)displayMessage, (IStatus)displayStatus);
                }
            }
        };
        HibernateConsolePlugin.openDialog(providedShell, openable, flags);
        return status;
    }

    public static void openDialog(Shell providedShell, final IOpenableInShell openable, int flags) {
        IWorkbenchWindow window;
        if (providedShell == null && (window = HibernateConsolePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow()) != null) {
            providedShell = window.getShell();
            flags |= 1;
        }
        final Shell shell = providedShell;
        Runnable outerRunnable = new Runnable(){

            @Override
            public void run() {
                Shell displayShell;
                if (shell == null) {
                    Display display = Display.getCurrent();
                    displayShell = new Shell(display);
                } else {
                    displayShell = shell;
                }
                openable.open(displayShell);
                if (shell == null) {
                    displayShell.dispose();
                }
            }
        };
        if (shell == null || (flags & 1) > 0) {
            Display display;
            if (shell == null) {
                display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
            } else {
                display = shell.getDisplay();
            }
            display.syncExec(outerRunnable);
        } else {
            outerRunnable.run();
        }
    }

    public static Shell getShell() {
        if (HibernateConsolePlugin.getActiveWorkbenchWindow() != null) {
            return HibernateConsolePlugin.getActiveWorkbenchWindow().getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return HibernateConsolePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public JavaTextTools getJavaTextTools() {
        if (this.javaTextTools == null) {
            this.javaTextTools = new JavaTextTools(PreferenceConstants.getPreferenceStore()){

                public void setupJavaDocumentPartitioner(IDocument document, String partitioning) {
                    IDocumentPartitioner partitioner = this.createDocumentPartitioner();
                    if (document instanceof IDocumentExtension3) {
                        IDocumentExtension3 extension3 = (IDocumentExtension3)document;
                        partitioner.connect(document);
                        extension3.setDocumentPartitioner(partitioning, partitioner);
                    } else {
                        document.setDocumentPartitioner(partitioner);
                        partitioner.connect(document);
                    }
                }
            };
        }
        return this.javaTextTools;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    public void logWarning(HibernateException he) {
        this.logMessage(2, he == null ? null : he.getMessage(), he);
    }

    public static interface IOpenableInShell {
        public void open(Shell var1);
    }
}

