/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console;

import java.io.File;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.hibernate.eclipse.console.HibernateConsolePlugin;

public class HibernateConsoleSaveParticipant
implements ISaveParticipant {
    static final String SAVENAME = "hibernate-console.xml";

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void saving(ISaveContext context) throws CoreException {
        switch (context.getKind()) {
            case 1: 
            case 2: 
            case 3: {
                int saveNumber = context.getSaveNumber();
                String saveFileName = "hibernate-console.xml-" + Integer.toString(saveNumber);
                File f = HibernateConsolePlugin.getDefault().getStateLocation().append(saveFileName).toFile();
                HibernateConsolePlugin.getDefault().writeStateTo(f);
                context.map((IPath)new Path(SAVENAME), (IPath)new Path(saveFileName));
                context.needSaveNumber();
            }
        }
    }

    public void doneSaving(ISaveContext context) {
        HibernateConsolePlugin myPluginInstance = HibernateConsolePlugin.getDefault();
        int previousSaveNumber = context.getPreviousSaveNumber();
        String oldFileName = "hibernate-console.xml-" + Integer.toString(previousSaveNumber);
        File f = myPluginInstance.getStateLocation().append(oldFileName).toFile();
        f.delete();
    }

    public void rollback(ISaveContext context) {
        HibernateConsolePlugin myPluginInstance = HibernateConsolePlugin.getDefault();
        int saveNumber = context.getSaveNumber();
        String saveFileName = "hibernate-console.xml-" + Integer.toString(saveNumber);
        File f = myPluginInstance.getStateLocation().append(saveFileName).toFile();
        f.delete();
    }

    public void doStart(HibernateConsolePlugin plugin) throws CoreException {
        ISavedState lastState = ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)plugin, (ISaveParticipant)this);
        if (lastState == null) {
            return;
        }
        IPath location = lastState.lookup((IPath)new Path(SAVENAME));
        if (location == null) {
            return;
        }
        File f = plugin.getStateLocation().append(location).toFile();
        plugin.readStateFrom(f);
    }
}

