/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.utils.xpl;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.hibernate.eclipse.console.HibernateConsolePlugin;

public class SelectionHelper {
    public static IType getClassFromElement(IJavaElement element) {
        IType classToTest = null;
        if (element != null) {
            IType typeInCompUnit = (IType)element.getAncestor(7);
            if (typeInCompUnit != null) {
                if (typeInCompUnit.getCompilationUnit() != null) {
                    classToTest = typeInCompUnit;
                }
            } else {
                ICompilationUnit cu = (ICompilationUnit)element.getAncestor(5);
                if (cu != null) {
                    classToTest = cu.findPrimaryType();
                } else if (element instanceof IClassFile) {
                    try {
                        IClassFile cf = (IClassFile)element;
                        if (cf.isStructureKnown()) {
                            classToTest = cf.getType();
                        }
                    }
                    catch (JavaModelException e) {
                        HibernateConsolePlugin.getDefault().log(e);
                    }
                }
            }
        }
        return classToTest;
    }

    public static IJavaElement getInitialJavaElement(ISelection simpleSelection) {
        IResource resource;
        IAdaptable adaptable;
        IStructuredSelection selection;
        Object selectedElement;
        IJavaElement jelem = null;
        if (simpleSelection != null && !simpleSelection.isEmpty() && simpleSelection instanceof IStructuredSelection && (selectedElement = (selection = (IStructuredSelection)simpleSelection).getFirstElement()) instanceof IAdaptable && (jelem = (IJavaElement)(adaptable = (IAdaptable)selectedElement).getAdapter(IJavaElement.class)) == null && (resource = (IResource)adaptable.getAdapter(IResource.class)) != null && resource.getType() != 8) {
            while (jelem == null && resource.getType() != 4) {
                resource = resource.getParent();
                jelem = (IJavaElement)resource.getAdapter(IJavaElement.class);
            }
            if (jelem == null) {
                jelem = JavaCore.create((IResource)resource);
            }
        }
        if (jelem == null) {
            Object elem;
            IWorkbenchPart part = SelectionHelper.getActivePage().getActivePart();
            if (part instanceof ContentOutline) {
                part = SelectionHelper.getActivePage().getActiveEditor();
            }
            if (part instanceof IViewPartInputProvider && (elem = ((IViewPartInputProvider)part).getViewPartInput()) instanceof IJavaElement) {
                jelem = (IJavaElement)elem;
            }
        }
        return jelem;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = SelectionHelper.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return SelectionHelper.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }
}

