/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views;

import java.util.Iterator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.actions.ConsoleConfigReadyUseBaseAction;
import org.hibernate.tool.hbm2ddl.SchemaExport;

public class SchemaExportAction
extends ConsoleConfigReadyUseBaseAction {
    public static final String SCHEMAEXPORT_ACTIONID = "actionid.schemaexport";

    protected SchemaExportAction(String text) {
        super(text);
        this.setId(SCHEMAEXPORT_ACTIONID);
        this.init(null);
    }

    public SchemaExportAction(StructuredViewer selectionProvider) {
        super(HibernateConsoleMessages.SchemaExportAction_run_schemaexport);
        this.setId(SCHEMAEXPORT_ACTIONID);
        this.init(selectionProvider);
    }

    public static boolean openWarningYesNoDlg(Shell parent, String title, String msg) {
        String[] dialogButtonLabels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
        MessageDialog dialog = new MessageDialog(parent, title, null, msg, 4, dialogButtonLabels, 0);
        return dialog.open() == 0;
    }

    @Override
    public void doRun() {
        for (Object node : this.getSelectedNonResources()) {
            if (!(node instanceof ConsoleConfiguration)) continue;
            final ConsoleConfiguration config = (ConsoleConfiguration)node;
            try {
                config.execute(new ExecutionContext.Command(){

                    public Object execute() {
                        Configuration cfg = config.getConfiguration();
                        if (cfg == null) {
                            return null;
                        }
                        String out = NLS.bind((String)HibernateConsoleMessages.SchemaExportAction_sure_run_schemaexport, (Object)config.getName());
                        boolean res = SchemaExportAction.openWarningYesNoDlg(SchemaExportAction.this.viewer.getControl().getShell(), HibernateConsoleMessages.SchemaExportAction_run_schemaexport, out);
                        if (!res) {
                            return null;
                        }
                        SchemaExport export = new SchemaExport(cfg);
                        export.create(false, true);
                        if (!export.getExceptions().isEmpty()) {
                            Iterator iterator = export.getExceptions().iterator();
                            int cnt = 1;
                            while (iterator.hasNext()) {
                                Throwable element = (Throwable)iterator.next();
                                String outStr = NLS.bind((String)HibernateConsoleMessages.SchemaExportAction_errornum_while_performing_schemaexport, (Object)cnt++);
                                HibernateConsolePlugin.getDefault().logErrorMessage(outStr, element);
                            }
                            HibernateConsolePlugin.getDefault().showError(SchemaExportAction.this.viewer.getControl().getShell(), NLS.bind((String)HibernateConsoleMessages.SchemaExportAction_error_while_performing_schemaexport, (Object)(cnt - 1)), (Throwable)null);
                        }
                        return null;
                    }
                });
                this.viewer.refresh(node);
            }
            catch (HibernateException he) {
                HibernateConsolePlugin.getDefault().showError(this.viewer.getControl().getShell(), HibernateConsoleMessages.SchemaExportAction_exception_running_schemaexport, he);
            }
        }
    }
}

