/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views.properties;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.hibernate.console.QueryPage;
import org.hibernate.eclipse.console.HibernateConsoleMessages;

public class QueryPagePropertySource
implements IPropertySource2 {
    private final QueryPage page;
    static IPropertyDescriptor[] descriptors;
    private static final String QUERY_TEXT = "QueryPage.queryString";
    private static final Object CONFIGURATION_TEXT;
    private static final String QUERY_SIZE = "QueryPage.size";
    private static final String QUERY_TIME = "QueryPage.time";
    private static final String TAB_NAME = "QueryPage.tabName";

    static {
        CONFIGURATION_TEXT = "QueryPage.consoleConfiguration";
        descriptors = new IPropertyDescriptor[5];
        TextPropertyDescriptor descriptor = new TextPropertyDescriptor((Object)QUERY_TEXT, HibernateConsoleMessages.QueryPagePropertySource_query_string);
        descriptor.setAlwaysIncompatible(false);
        QueryPagePropertySource.descriptors[0] = descriptor;
        descriptor = new TextPropertyDescriptor(CONFIGURATION_TEXT, HibernateConsoleMessages.QueryPagePropertySource_console_configuration);
        descriptor.setAlwaysIncompatible(false);
        QueryPagePropertySource.descriptors[1] = descriptor;
        descriptor = new TextPropertyDescriptor((Object)QUERY_SIZE, HibernateConsoleMessages.QueryPagePropertySource_query_size);
        descriptor.setAlwaysIncompatible(false);
        QueryPagePropertySource.descriptors[2] = descriptor;
        descriptor = new TextPropertyDescriptor((Object)QUERY_TIME, HibernateConsoleMessages.QueryPagePropertySource_query_run_time);
        descriptor.setAlwaysIncompatible(false);
        QueryPagePropertySource.descriptors[3] = descriptor;
        descriptor = new TextPropertyDescriptor((Object)TAB_NAME, HibernateConsoleMessages.QueryPagePropertySource_tab_name);
        descriptor.setAlwaysIncompatible(false);
        QueryPagePropertySource.descriptors[4] = descriptor;
    }

    public QueryPagePropertySource(QueryPage page) {
        this.page = page;
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public Object getEditableValue() {
        return "";
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    public Object getPropertyValue(Object id) {
        if (CONFIGURATION_TEXT.equals(id)) {
            return this.page.getHibernateExtension().getConsoleConfigurationName();
        }
        if (QUERY_TEXT.equals(id)) {
            return this.page.getQueryString();
        }
        if (QUERY_SIZE.equals(id)) {
            int resultSize = this.page.getResultSize();
            return resultSize == -1 ? HibernateConsoleMessages.QueryPagePropertySource_unknown : String.valueOf(resultSize);
        }
        if (QUERY_TIME.equals(id)) {
            long resultTime = this.page.getQueryTime();
            if (resultTime == -1L) {
                return HibernateConsoleMessages.QueryPagePropertySource_unknown;
            }
            if (resultTime > 1000L) {
                return NLS.bind((String)HibernateConsoleMessages.QueryPagePropertySource_sec, (Object)(String.valueOf(resultTime / 1000L) + "." + resultTime / 100L % 10L));
            }
            return NLS.bind((String)HibernateConsoleMessages.QueryPagePropertySource_millisec, (Object)resultTime);
        }
        if (TAB_NAME.equals(id)) {
            return this.page.getTabName();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
        if (TAB_NAME.equals(id)) {
            this.page.setTabName(this.page.getQueryString().replace('\n', ' ').replace('\r', ' '));
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (TAB_NAME.equals(id)) {
            this.page.setTabName(value == null ? "<null>" : value.toString());
        }
    }
}

