/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.criteriaeditor;

import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.texteditor.ITextEditor;
import org.hibernate.eclipse.criteriaeditor.CriteriaEditor;
import org.hibernate.eclipse.criteriaeditor.JavaCompletionProcessor;

public class JavaViewerConfiguration
extends JavaSourceViewerConfiguration {
    private IPreferenceStore preferenceStore;

    public JavaViewerConfiguration(JavaTextTools tools, IPreferenceStore preferenceStore, CriteriaEditor editor) {
        super(tools.getColorManager(), preferenceStore, (ITextEditor)editor, "___java_partitioning");
        this.preferenceStore = preferenceStore;
    }

    public IContentAssistProcessor getContentAssistantProcessor() {
        return new JavaCompletionProcessor((CriteriaEditor)this.getEditor());
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor(this.getContentAssistantProcessor(), "__dftl_partition_content_type");
        JavaViewerConfiguration.configure(assistant, this.preferenceStore, this.getColorManager());
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        return null;
    }

    public static void configure(ContentAssistant assistant, IPreferenceStore store, IColorManager manager) {
        boolean enabled = store.getBoolean("content_assist_autoactivation");
        assistant.enableAutoActivation(enabled);
        int delay = store.getInt("content_assist_autoactivation_delay");
        assistant.setAutoActivationDelay(delay);
        Color c = JavaViewerConfiguration.getColor(store, "content_assist_proposals_foreground", manager);
        assistant.setProposalSelectorForeground(c);
        c = JavaViewerConfiguration.getColor(store, "content_assist_proposals_background", manager);
        assistant.setProposalSelectorBackground(c);
        c = JavaViewerConfiguration.getColor(store, "content_assist_parameters_foreground", manager);
        assistant.setContextInformationPopupForeground(c);
        assistant.setContextSelectorForeground(c);
        c = JavaViewerConfiguration.getColor(store, "content_assist_parameters_background", manager);
        assistant.setContextInformationPopupBackground(c);
        assistant.setContextSelectorBackground(c);
        enabled = store.getBoolean("content_assist_autoinsert");
        assistant.enableAutoInsert(enabled);
        JavaCompletionProcessor cp = JavaViewerConfiguration.getJavaProcessor(assistant);
        if (cp != null) {
            String triggers = store.getString("content_assist_autoactivation_triggers_java");
            if (triggers != null) {
                cp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
            }
            enabled = store.getBoolean("content_assist_order_proposals");
            cp.orderProposalsAlphabetically(enabled);
        }
    }

    private static JavaCompletionProcessor getJavaProcessor(ContentAssistant assistant) {
        IContentAssistProcessor p = assistant.getContentAssistProcessor("__dftl_partition_content_type");
        if (p instanceof JavaCompletionProcessor) {
            return (JavaCompletionProcessor)p;
        }
        return null;
    }

    private static Color getColor(IPreferenceStore store, String key, IColorManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }
}

