/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph;

import java.util.ArrayList;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.ViewPart;
import org.hibernate.eclipse.graph.GraphViewActionGroup;
import org.hibernate.eclipse.graph.HibernateConfigurationPartFactory;
import org.hibernate.eclipse.graph.model.ConfigurationViewAdapter;
import org.hibernate.eclipse.graph.parts.ConfigurationEditPart;

public abstract class AbstractGraphViewPart
extends ViewPart {
    protected ISelectionListener listener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            AbstractGraphViewPart.this.selectionChanged((IStructuredSelection)selection);
        }
    };
    protected ScrollingGraphicalViewer viewer;
    protected EditDomain editDomain;
    private ActionGroup actionGroup;

    public void createPartControl(Composite parent) {
        this.viewer = new ScrollingGraphicalViewer();
        this.viewer.createControl(parent);
        this.viewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
        this.viewer.getControl().setBackground(ColorConstants.white);
        this.viewer.setEditPartFactory((EditPartFactory)this.createEditPartFactory());
        this.editDomain.addViewer((EditPartViewer)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.setupListener();
        this.initActions();
    }

    protected HibernateConfigurationPartFactory createEditPartFactory() {
        return new HibernateConfigurationPartFactory();
    }

    protected abstract void setupListener();

    private void initActions() {
        ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)this.viewer.getRootEditPart();
        this.actionGroup = new GraphViewActionGroup(this, "org.hibernate.eclipse.console.view.entitygraph.manuallayout", root);
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.actionGroup.fillActionBars(actionBars);
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        root.getZoomManager().setZoomLevelContributions(zoomLevels);
        root.getZoomManager().setZoomLevels(new double[]{0.067, 0.125, 0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0});
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.initEditDomain();
    }

    private void initEditDomain() {
        this.editDomain = new EditDomain();
    }

    public void setFocus() {
    }

    public void dispose() {
        this.disposeListeners();
    }

    protected abstract void disposeListeners();

    public void setManualLayout(boolean value) {
        ConfigurationEditPart cp = (ConfigurationEditPart)this.viewer.getContents();
        if (cp != null) {
            cp.setManualLayoutActive(value);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(GraphicalViewer.class)) {
            return this.viewer;
        }
        return super.getAdapter(adapter);
    }

    protected abstract void selectionChanged(IStructuredSelection var1);

    public ConfigurationViewAdapter getConfigurationViewAdapter() {
        ConfigurationEditPart cp = (ConfigurationEditPart)this.viewer.getContents();
        if (cp != null) {
            return cp.getConfigurationViewAdapter();
        }
        return null;
    }
}

