/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class EditableLabel
extends Label {
    private boolean selected;

    public EditableLabel(String text) {
        super(text);
        this.setLabelAlignment(1);
    }

    private Rectangle getSelectionRectangle() {
        Rectangle bounds = this.getTextBounds().getCopy();
        bounds.expand(new Insets(2, 2, 0, 0));
        this.translateToParent((Translatable)bounds);
        bounds.intersect(this.getBounds());
        return bounds;
    }

    protected void paintFigure(Graphics graphics) {
        if (this.selected) {
            graphics.pushState();
            graphics.setBackgroundColor(ColorConstants.menuBackgroundSelected);
            graphics.fillRectangle(this.getSelectionRectangle());
            graphics.popState();
            graphics.setForegroundColor(ColorConstants.white);
        }
        super.paintFigure(graphics);
    }

    public void setSelected(boolean b) {
        this.selected = b;
        this.repaint();
    }
}

